/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelwriter;

import org.apache.commons.vfs2.FileObject;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriterWorkbookDefinition {
    private FileObject file;
    private String fileName;
    private Workbook workbook;
    private Sheet sheet;
    private int posX;
    private int posY;
    private int datalines;
    private int splitNr;
    private CellStyle[] cellStyleCache;
    private CellStyle[] cellLinkStyleCache;

    public ExcelWriterWorkbookDefinition(String fileName, FileObject file, Workbook workbook, Sheet sheet, int posX, int posY) {
        this.fileName = fileName;
        this.file = file;
        this.workbook = workbook;
        this.sheet = sheet;
        this.posX = posX;
        this.posY = posY;
        this.datalines = 0;
        this.splitNr = 0;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFile(FileObject file) {
        this.file = file;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getDatalines() {
        return this.datalines;
    }

    public void setDatalines(int datalines) {
        this.datalines = datalines;
    }

    public int getSplitNr() {
        return this.splitNr;
    }

    public void setSplitNr(int splitNr) {
        this.splitNr = splitNr;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void incrementY() {
        ++this.posY;
    }

    public void incrementX() {
        ++this.posX;
    }

    public void clearStyleCache(int nrFields) {
        this.cellStyleCache = new CellStyle[nrFields];
        this.cellLinkStyleCache = new CellStyle[nrFields];
    }

    public void cacheStyle(int fieldNr, CellStyle style) {
        this.cellStyleCache[fieldNr] = style;
    }

    public void cacheLinkStyle(int fieldNr, CellStyle style) {
        this.cellLinkStyleCache[fieldNr] = style;
    }

    public CellStyle getCachedStyle(int fieldNr) {
        return this.cellStyleCache[fieldNr];
    }

    public CellStyle getCachedLinkStyle(int fieldNr) {
        return this.cellLinkStyleCache[fieldNr];
    }

    public CellStyle[] getCellStyleCache() {
        return this.cellStyleCache;
    }

    public void setCellStyleCache(CellStyle[] cellStyleCache) {
        this.cellStyleCache = cellStyleCache;
    }

    public CellStyle[] getCellLinkStyleCache() {
        return this.cellLinkStyleCache;
    }

    public void setCellLinkStyleCache(CellStyle[] cellLinkStyleCache) {
        this.cellLinkStyleCache = cellLinkStyleCache;
    }
}

