/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String tableName;
    private String indexName;
    private List<String> attributesToGet;
    private Integer limit;
    private String select;
    private Map<String, Condition> scanFilter;
    private String conditionalOperator;
    private Map<String, AttributeValue> exclusiveStartKey;
    private String returnConsumedCapacity;
    private Integer totalSegments;
    private Integer segment;
    private String projectionExpression;
    private String filterExpression;
    private Map<String, String> expressionAttributeNames;
    private Map<String, AttributeValue> expressionAttributeValues;
    private Boolean consistentRead;

    public ScanRequest() {
    }

    public ScanRequest(String tableName) {
        this.setTableName(tableName);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ScanRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ScanRequest withIndexName(String indexName) {
        this.setIndexName(indexName);
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        this.attributesToGet = new ArrayList<String>(attributesToGet);
    }

    public ScanRequest withAttributesToGet(String ... attributesToGet) {
        if (this.attributesToGet == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String ele : attributesToGet) {
            this.attributesToGet.add(ele);
        }
        return this;
    }

    public ScanRequest withAttributesToGet(Collection<String> attributesToGet) {
        this.setAttributesToGet(attributesToGet);
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ScanRequest withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getSelect() {
        return this.select;
    }

    public ScanRequest withSelect(String select) {
        this.setSelect(select);
        return this;
    }

    public void setSelect(Select select) {
        this.withSelect(select);
    }

    public ScanRequest withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public Map<String, Condition> getScanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(Map<String, Condition> scanFilter) {
        this.scanFilter = scanFilter;
    }

    public ScanRequest withScanFilter(Map<String, Condition> scanFilter) {
        this.setScanFilter(scanFilter);
        return this;
    }

    public ScanRequest addScanFilterEntry(String key, Condition value) {
        if (null == this.scanFilter) {
            this.scanFilter = new HashMap<String, Condition>();
        }
        if (this.scanFilter.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.scanFilter.put(key, value);
        return this;
    }

    public ScanRequest clearScanFilterEntries() {
        this.scanFilter = null;
        return this;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public ScanRequest withConditionalOperator(String conditionalOperator) {
        this.setConditionalOperator(conditionalOperator);
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.withConditionalOperator(conditionalOperator);
    }

    public ScanRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public ScanRequest withExclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
        this.setExclusiveStartKey(exclusiveStartKey);
        return this;
    }

    public ScanRequest addExclusiveStartKeyEntry(String key, AttributeValue value) {
        if (null == this.exclusiveStartKey) {
            this.exclusiveStartKey = new HashMap<String, AttributeValue>();
        }
        if (this.exclusiveStartKey.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.exclusiveStartKey.put(key, value);
        return this;
    }

    public ScanRequest clearExclusiveStartKeyEntries() {
        this.exclusiveStartKey = null;
        return this;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public ScanRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.withReturnConsumedCapacity(returnConsumedCapacity);
    }

    public ScanRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public void setTotalSegments(Integer totalSegments) {
        this.totalSegments = totalSegments;
    }

    public Integer getTotalSegments() {
        return this.totalSegments;
    }

    public ScanRequest withTotalSegments(Integer totalSegments) {
        this.setTotalSegments(totalSegments);
        return this;
    }

    public void setSegment(Integer segment) {
        this.segment = segment;
    }

    public Integer getSegment() {
        return this.segment;
    }

    public ScanRequest withSegment(Integer segment) {
        this.setSegment(segment);
        return this;
    }

    public void setProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public ScanRequest withProjectionExpression(String projectionExpression) {
        this.setProjectionExpression(projectionExpression);
        return this;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public ScanRequest withFilterExpression(String filterExpression) {
        this.setFilterExpression(filterExpression);
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public ScanRequest withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public ScanRequest addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public ScanRequest clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public Map<String, AttributeValue> getExpressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.expressionAttributeValues = expressionAttributeValues;
    }

    public ScanRequest withExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
        this.setExpressionAttributeValues(expressionAttributeValues);
        return this;
    }

    public ScanRequest addExpressionAttributeValuesEntry(String key, AttributeValue value) {
        if (null == this.expressionAttributeValues) {
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
        }
        if (this.expressionAttributeValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeValues.put(key, value);
        return this;
    }

    public ScanRequest clearExpressionAttributeValuesEntries() {
        this.expressionAttributeValues = null;
        return this;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public ScanRequest withConsistentRead(Boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setExclusiveStartKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        HashMap<String, AttributeValue> exclusiveStartKey = new HashMap<String, AttributeValue>();
        if (hashKey == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        exclusiveStartKey.put(hashKey.getKey(), hashKey.getValue());
        if (rangeKey != null) {
            exclusiveStartKey.put(rangeKey.getKey(), rangeKey.getValue());
        }
        this.setExclusiveStartKey(exclusiveStartKey);
    }

    public ScanRequest withExclusiveStartKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        this.setExclusiveStartKey(hashKey, rangeKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getIndexName() != null) {
            sb.append("IndexName: ").append(this.getIndexName()).append(",");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.getAttributesToGet()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getSelect() != null) {
            sb.append("Select: ").append(this.getSelect()).append(",");
        }
        if (this.getScanFilter() != null) {
            sb.append("ScanFilter: ").append(this.getScanFilter()).append(",");
        }
        if (this.getConditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(this.getConditionalOperator()).append(",");
        }
        if (this.getExclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: ").append(this.getExclusiveStartKey()).append(",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.getReturnConsumedCapacity()).append(",");
        }
        if (this.getTotalSegments() != null) {
            sb.append("TotalSegments: ").append(this.getTotalSegments()).append(",");
        }
        if (this.getSegment() != null) {
            sb.append("Segment: ").append(this.getSegment()).append(",");
        }
        if (this.getProjectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.getProjectionExpression()).append(",");
        }
        if (this.getFilterExpression() != null) {
            sb.append("FilterExpression: ").append(this.getFilterExpression()).append(",");
        }
        if (this.getExpressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.getExpressionAttributeNames()).append(",");
        }
        if (this.getExpressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.getExpressionAttributeValues()).append(",");
        }
        if (this.getConsistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.getConsistentRead());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRequest)) {
            return false;
        }
        ScanRequest other = (ScanRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !other.getAttributesToGet().equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getSelect() == null ^ this.getSelect() == null) {
            return false;
        }
        if (other.getSelect() != null && !other.getSelect().equals(this.getSelect())) {
            return false;
        }
        if (other.getScanFilter() == null ^ this.getScanFilter() == null) {
            return false;
        }
        if (other.getScanFilter() != null && !other.getScanFilter().equals(this.getScanFilter())) {
            return false;
        }
        if (other.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (other.getConditionalOperator() != null && !other.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (other.getExclusiveStartKey() == null ^ this.getExclusiveStartKey() == null) {
            return false;
        }
        if (other.getExclusiveStartKey() != null && !other.getExclusiveStartKey().equals(this.getExclusiveStartKey())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (other.getReturnConsumedCapacity() != null && !other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (other.getTotalSegments() == null ^ this.getTotalSegments() == null) {
            return false;
        }
        if (other.getTotalSegments() != null && !other.getTotalSegments().equals(this.getTotalSegments())) {
            return false;
        }
        if (other.getSegment() == null ^ this.getSegment() == null) {
            return false;
        }
        if (other.getSegment() != null && !other.getSegment().equals(this.getSegment())) {
            return false;
        }
        if (other.getProjectionExpression() == null ^ this.getProjectionExpression() == null) {
            return false;
        }
        if (other.getProjectionExpression() != null && !other.getProjectionExpression().equals(this.getProjectionExpression())) {
            return false;
        }
        if (other.getFilterExpression() == null ^ this.getFilterExpression() == null) {
            return false;
        }
        if (other.getFilterExpression() != null && !other.getFilterExpression().equals(this.getFilterExpression())) {
            return false;
        }
        if (other.getExpressionAttributeNames() == null ^ this.getExpressionAttributeNames() == null) {
            return false;
        }
        if (other.getExpressionAttributeNames() != null && !other.getExpressionAttributeNames().equals(this.getExpressionAttributeNames())) {
            return false;
        }
        if (other.getExpressionAttributeValues() == null ^ this.getExpressionAttributeValues() == null) {
            return false;
        }
        if (other.getExpressionAttributeValues() != null && !other.getExpressionAttributeValues().equals(this.getExpressionAttributeValues())) {
            return false;
        }
        if (other.getConsistentRead() == null ^ this.getConsistentRead() == null) {
            return false;
        }
        return other.getConsistentRead() == null || other.getConsistentRead().equals(this.getConsistentRead());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : this.getAttributesToGet().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSelect() == null ? 0 : this.getSelect().hashCode());
        hashCode = 31 * hashCode + (this.getScanFilter() == null ? 0 : this.getScanFilter().hashCode());
        hashCode = 31 * hashCode + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        hashCode = 31 * hashCode + (this.getExclusiveStartKey() == null ? 0 : this.getExclusiveStartKey().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTotalSegments() == null ? 0 : this.getTotalSegments().hashCode());
        hashCode = 31 * hashCode + (this.getSegment() == null ? 0 : this.getSegment().hashCode());
        hashCode = 31 * hashCode + (this.getProjectionExpression() == null ? 0 : this.getProjectionExpression().hashCode());
        hashCode = 31 * hashCode + (this.getFilterExpression() == null ? 0 : this.getFilterExpression().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeNames() == null ? 0 : this.getExpressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeValues() == null ? 0 : this.getExpressionAttributeValues().hashCode());
        hashCode = 31 * hashCode + (this.getConsistentRead() == null ? 0 : this.getConsistentRead().hashCode());
        return hashCode;
    }

    public ScanRequest clone() {
        return (ScanRequest)super.clone();
    }
}

