/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.formula.Formula;
import org.apache.hop.pipeline.transforms.formula.FormulaData;
import org.apache.hop.pipeline.transforms.formula.FormulaMetaFunction;

@Transform(id="Formula", image="formula.svg", name="i18n::Formula.name", description="i18n::Formula.description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::Formula.keywords"}, documentationUrl="/pipeline/transforms/formula.html")
public class FormulaMeta
extends BaseTransformMeta<Formula, FormulaData> {
    @HopMetadataProperty(groupKey="formulas", key="formula", injectionGroupDescription="FormulaMeta.Injection.Formulas", injectionKeyDescription="FormulaMeta.Injection.Formula")
    private List<FormulaMetaFunction> formulas;

    public FormulaMeta() {
        this.formulas = new ArrayList<FormulaMetaFunction>();
    }

    public FormulaMeta(FormulaMeta m) {
        this.formulas = m.formulas;
    }

    public void setFormulas(List<FormulaMetaFunction> formulas) {
        this.formulas = formulas;
    }

    public List<FormulaMetaFunction> getFormulas() {
        return this.formulas;
    }

    public Object clone() {
        return new FormulaMeta(this);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (FormulaMetaFunction formula : this.formulas) {
            if (Utils.isEmpty((CharSequence)formula.getReplaceField())) {
                if (Utils.isEmpty((CharSequence)formula.getFieldName())) continue;
                try {
                    IValueMeta v = ValueMetaFactory.createValueMeta((String)formula.getFieldName(), (int)formula.getValueType());
                    v.setLength(formula.getValueLength(), formula.getValuePrecision());
                    v.setOrigin(name);
                    row.addValueMeta(v);
                    continue;
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
            int index = row.indexOfValue(formula.getReplaceField());
            if (index < 0) {
                throw new HopTransformException("Unknown field specified to replace with a formula result: [" + formula.getReplaceField() + "]");
            }
            IValueMeta v = row.getValueMeta(index).clone();
            v.setLength(formula.getValueLength(), formula.getValuePrecision());
            v.setOrigin(name);
            row.setValueMeta(index, v);
        }
    }
}

