/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VPropertiesAction
implements VAction,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String applyText_ = ResourceLoader.getText("DLG_APPLY");
    private static final String cancelText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String okText_ = ResourceLoader.getText("DLG_OK");
    private static final String propertiesActionText_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String propertiesDialogText_ = ResourceLoader.getText("DLG_PROPERTIES_TITLE");
    private boolean enabled_ = true;
    private VObject object_ = null;
    private static Hashtable visibleDialogs_ = new Hashtable();
    transient ErrorEventSupport errorEventSupport_;
    transient VObjectEventSupport objectEventSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public VPropertiesAction() {
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    void applyChanges(VPropertiesPane vPropertiesPane) {
        try {
            vPropertiesPane.applyChanges();
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }

    static void disposeDialog(VObject vObject) {
        JDialog jDialog = (JDialog)visibleDialogs_.get(vObject);
        jDialog.dispose();
        visibleDialogs_.remove(vObject);
    }

    public VObject getObject() {
        return this.object_;
    }

    public String getText() {
        return propertiesActionText_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
    }

    public void perform(VActionContext vActionContext) {
        if (vActionContext == null) {
            throw new NullPointerException("context");
        }
        if (this.enabled_ && this.object_ != null) {
            VPropertiesPane vPropertiesPane;
            final VPropertiesPane vPropertiesPane2 = vPropertiesPane = this.object_.getPropertiesPane();
            final VObject vObject = this.object_;
            if (vPropertiesPane != null) {
                if (visibleDialogs_.containsKey(this.object_)) {
                    JDialog jDialog = (JDialog)visibleDialogs_.get(this.object_);
                    jDialog.toFront();
                    jDialog.requestFocus();
                } else {
                    JButton jButton;
                    String string = ResourceLoader.substitute(propertiesDialogText_, this.object_.getText());
                    vPropertiesPane.addErrorListener(this.errorEventSupport_);
                    vPropertiesPane.addVObjectListener(this.objectEventSupport_);
                    vPropertiesPane.addWorkingListener(this.workingEventSupport_);
                    final JButton jButton2 = jButton = new JButton(applyText_);
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            VPropertiesAction.this.applyChanges(vPropertiesPane2);
                            jButton2.setEnabled(false);
                        }
                    });
                    jButton.setEnabled(false);
                    JButton jButton3 = new JButton(cancelText_);
                    jButton3.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            vPropertiesPane2.removeErrorListener(VPropertiesAction.this.errorEventSupport_);
                            vPropertiesPane2.removeVObjectListener(VPropertiesAction.this.objectEventSupport_);
                            vPropertiesPane2.removeWorkingListener(VPropertiesAction.this.workingEventSupport_);
                            VPropertiesAction.disposeDialog(vObject);
                        }
                    });
                    JButton jButton4 = new JButton(okText_);
                    jButton4.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            VPropertiesAction.this.applyChanges(vPropertiesPane2);
                            vPropertiesPane2.removeErrorListener(VPropertiesAction.this.errorEventSupport_);
                            vPropertiesPane2.removeVObjectListener(VPropertiesAction.this.objectEventSupport_);
                            vPropertiesPane2.removeWorkingListener(VPropertiesAction.this.workingEventSupport_);
                            VPropertiesAction.disposeDialog(vObject);
                        }
                    });
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout(2));
                    jPanel.add(jButton4);
                    jPanel.add(jButton3);
                    jPanel.add(jButton);
                    jButton4.setSelected(true);
                    Component component = vPropertiesPane.getComponent();
                    JDialog jDialog = new JDialog(vActionContext.getFrame(), string, false);
                    jDialog.getContentPane().setLayout(new BorderLayout());
                    jDialog.getContentPane().add("South", jPanel);
                    jDialog.getContentPane().add("Center", component);
                    jDialog.setResizable(false);
                    jDialog.pack();
                    jDialog.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            VPropertiesAction.disposeDialog(vObject);
                        }
                    });
                    vPropertiesPane.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            jButton2.setEnabled(true);
                        }
                    });
                    VPropertiesAction.showDialog(vObject, jDialog);
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setEnabled(boolean bl) {
        this.enabled_ = bl;
    }

    public void setObject(VObject vObject) {
        if (vObject == null) {
            throw new NullPointerException("object");
        }
        this.object_ = vObject;
    }

    static void showDialog(VObject vObject, JDialog jDialog) {
        visibleDialogs_.put(vObject, jDialog);
        jDialog.show();
    }

    public String toString() {
        return propertiesActionText_;
    }
}

