/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.DestinationUnreachable;
import com.ibm.as400.util.commtrace.EchoReplyRequest;
import com.ibm.as400.util.commtrace.EchoRequest;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.ICMP6Header;
import com.ibm.as400.util.commtrace.MulticastListenerDone;
import com.ibm.as400.util.commtrace.MulticastListenerQuery;
import com.ibm.as400.util.commtrace.MulticastListenerReport;
import com.ibm.as400.util.commtrace.NeighborAdvertisement;
import com.ibm.as400.util.commtrace.NeighborSolicitation;
import com.ibm.as400.util.commtrace.PacketTooBig;
import com.ibm.as400.util.commtrace.ParameterProblem;
import com.ibm.as400.util.commtrace.Redirect;
import com.ibm.as400.util.commtrace.RouterAdvertisement;
import com.ibm.as400.util.commtrace.RouterSolicitation;
import com.ibm.as400.util.commtrace.TimeExceeded;
import com.ibm.as400.util.commtrace.UnknownMessage;

public abstract class Message
extends ICMP6Header {
    public static final int MSGUNK = 0;
    public static final int RTRSOL = 133;
    public static final int RTRADV = 134;
    public static final int NGHSOL = 135;
    public static final int NGHADV = 136;
    public static final int REDR = 137;
    public static final int DSTUNR = 1;
    public static final int PKTTOBIG = 2;
    public static final int TIMEEXC = 3;
    public static final int PARMPROB = 4;
    public static final int ECHOREQ = 128;
    public static final int ECHQRPL = 129;
    public static final int MLTLSTQRY = 130;
    public static final int MLTLSTRPT = 131;
    public static final int MLTLSTDNE = 132;
    static final String OFFPKT = "Offending IPPacket";
    static final String PTR = "Pointer";
    static final String ID = "Identifier";
    static final String SEQNUM = "SequenceNumber";
    static final String CURHOPLIMIT = "CurHopLimit";
    static final String RTRLIFETIME = "RouterLifeTime";
    static final String RCHTIME = "ReachableTime";
    static final String RETRANSTIME = "RetransTimer";
    static final String O = "O";
    static final String M = "M";
    static final String TARGET = "Target";
    static final String FLAGS = "Flags";
    static final String RTR = "Router";
    static final String SOL = "Solicited";
    static final String OVR = "Override";
    static final String DST = "Destination";
    static final String MAX = "Max Response Delay";
    static final String ADDR = "Address";

    Message(BitBuf bitBuf) {
        super(bitBuf);
    }

    static Message createMessage(byte by, BitBuf bitBuf) {
        int n = by & 0xFF;
        if (n == 133) {
            return new RouterSolicitation(bitBuf);
        }
        if (n == 134) {
            return new RouterAdvertisement(bitBuf);
        }
        if (n == 135) {
            return new NeighborSolicitation(bitBuf);
        }
        if (n == 136) {
            return new NeighborAdvertisement(bitBuf);
        }
        if (n == 137) {
            return new Redirect(bitBuf);
        }
        if (n == 1) {
            return new DestinationUnreachable(bitBuf);
        }
        if (n == 2) {
            return new PacketTooBig(bitBuf);
        }
        if (n == 3) {
            return new TimeExceeded(bitBuf);
        }
        if (n == 4) {
            return new ParameterProblem(bitBuf);
        }
        if (n == 128) {
            return new EchoRequest(bitBuf);
        }
        if (n == 129) {
            return new EchoReplyRequest(bitBuf);
        }
        if (n == 130) {
            return new MulticastListenerQuery(bitBuf);
        }
        if (n == 131) {
            return new MulticastListenerReport(bitBuf);
        }
        if (n == 132) {
            return new MulticastListenerDone(bitBuf);
        }
        return new UnknownMessage(bitBuf);
    }

    public String toString(FormatProperties formatProperties) {
        return this.printnext(formatProperties);
    }
}

