/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpaceEvent;
import com.ibm.as400.access.UserSpaceImpl;
import com.ibm.as400.access.UserSpaceListener;
import com.ibm.as400.access.UserSpaceNativeReadWriteImpl;
import com.ibm.as400.access.UserSpaceNativeReadWriteImplILE;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class UserSpace
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.UserSpace";
    static final long serialVersionUID = 4L;
    public static final int FORCE_ASYNCHRONOUS = 1;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SYNCHRONOUS = 2;
    public static final String DOMAIN_DEFAULT = "*DEFAULT";
    public static final String DOMAIN_USER = "*USER";
    public static final String DOMAIN_SYSTEM = "*SYSTEM";
    private static final int MAX_USER_SPACE_SIZE = 0xFFFE00;
    private AS400 system_ = null;
    private String path_ = "";
    private String library_ = "";
    private String name_ = "";
    private boolean mustUseProgramCall_ = false;
    private boolean mustUseSockets_ = false;
    private boolean mustUseNativeMethods_ = false;
    private transient Converter dataConverter_ = null;
    private transient UserSpaceImpl impl_ = null;
    private transient UserSpaceNativeReadWriteImpl nativeReadWriteImpl_ = null;
    private transient Vector userSpaceListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public UserSpace() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserSpace object.");
        }
    }

    public UserSpace(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserSpace object, system: " + aS400 + " path: " + string);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "USRSPC");
        this.system_ = aS400;
        this.path_ = string;
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.name_ = qSYSObjectPathName.getObjectName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.propertyChangeListeners_ == null) {
                    this.propertyChangeListeners_ = new PropertyChangeSupport(this);
                }
            }
        }
        this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserSpaceListener(UserSpaceListener userSpaceListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding user space listener.");
        }
        if (userSpaceListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.userSpaceListeners_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.userSpaceListeners_ == null) {
                    this.userSpaceListeners_ = new Vector();
                }
            }
        }
        this.userSpaceListeners_.addElement(userSpaceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.vetoableChangeListeners_ == null) {
                    this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
                }
            }
        }
        this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
    }

    private synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Cannot connect to the server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            if (this.path_.length() == 0) {
                Trace.log(2, "Cannot connect to the server before setting path.");
                throw new ExtendedIllegalStateException("path", 4);
            }
            this.impl_ = this.mustUseSockets_ ? (UserSpaceImpl)this.system_.loadImpl2("com.ibm.as400.access.UserSpaceImplRemote", "com.ibm.as400.access.UserSpaceImplProxy") : (UserSpaceImpl)this.system_.loadImpl3("com.ibm.as400.access.UserSpaceImplNative", "com.ibm.as400.access.UserSpaceImplRemote", "com.ibm.as400.access.UserSpaceImplProxy");
            this.impl_.setProperties(this.system_.getImpl(), this.path_, this.name_, this.library_, this.mustUseProgramCall_, this.mustUseSockets_);
        }
    }

    public synchronized void close() throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing user space.");
        }
        if (this.impl_ != null) {
            this.impl_.close();
        }
    }

    public void create(int n, boolean bl, String string, byte by, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.create(new byte[]{92, -60, -59, -58, -63, -28, -45, -29, 64, 64}, n, bl, string, by, string2, string3);
    }

    public void create(String string, int n, boolean bl, String string2, byte by, String string3, String string4) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray;
        if (string == null) {
            throw new NullPointerException("domain");
        }
        if (string.equals(DOMAIN_DEFAULT)) {
            byArray = new byte[]{92, -60, -59, -58, -63, -28, -45, -29, 64, 64};
        } else if (string.equals(DOMAIN_USER)) {
            byArray = new byte[]{92, -28, -30, -59, -39, 64, 64, 64, 64, 64};
        } else if (string.equals(DOMAIN_SYSTEM)) {
            byArray = new byte[]{92, -30, -24, -30, -29, -59, -44, 64, 64, 64};
        } else {
            throw new ExtendedIllegalArgumentException("domain (" + string + ")", 2);
        }
        this.create(byArray, n, bl, string2, by, string3, string4);
    }

    private void create(byte[] byArray, int n, boolean bl, String string, byte by, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Creating user space.");
        }
        if (n < 1 || n > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 4);
        }
        if (string == null) {
            throw new NullPointerException("extendedAttribute");
        }
        if (string.length() == 0) {
            string = " ";
        }
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("extendedAttribute (" + string + ")", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("textDescription");
        }
        if (string2.length() == 0) {
            string2 = " ";
        }
        if (string2.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription (" + string2 + ")", 1);
        }
        if (string3 == null) {
            throw new NullPointerException("authority");
        }
        if (string3.length() == 0 || string3.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority (" + string3 + ")", 1);
        }
        this.chooseImpl();
        this.impl_.create(byArray, n, bl, string, by, string2, string3);
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(0);
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting user space.");
        }
        this.chooseImpl();
        this.impl_.delete();
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(1);
        }
    }

    public boolean exists() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Determining user space existence.");
        }
        try {
            this.chooseImpl();
            this.impl_.getLength();
            return true;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            return false;
        }
    }

    private void fireUserSpaceEvent(int n) {
        Vector vector = (Vector)this.userSpaceListeners_.clone();
        UserSpaceEvent userSpaceEvent = new UserSpaceEvent(this, n);
        block6: for (int i = 0; i < vector.size(); ++i) {
            UserSpaceListener userSpaceListener = (UserSpaceListener)vector.elementAt(i);
            switch (n) {
                case 0: {
                    userSpaceListener.created(userSpaceEvent);
                    continue block6;
                }
                case 1: {
                    userSpaceListener.deleted(userSpaceEvent);
                    continue block6;
                }
                case 2: {
                    userSpaceListener.read(userSpaceEvent);
                    continue block6;
                }
                case 3: {
                    userSpaceListener.written(userSpaceEvent);
                }
            }
        }
    }

    public byte getInitialValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user space initial value.");
        }
        this.chooseImpl();
        return this.impl_.getInitialValue();
    }

    public int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user space length.");
        }
        this.chooseImpl();
        return this.impl_.getLength();
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user space name: " + this.name_);
        }
        return this.name_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user space path: " + this.path_);
        }
        return this.path_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public boolean isAutoExtendible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving user space auto extendibility.");
        }
        this.chooseImpl();
        return this.impl_.isAutoExtendible();
    }

    public boolean isMustUseProgramCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user space must use program call:", this.mustUseProgramCall_);
        }
        return this.mustUseProgramCall_;
    }

    public boolean isMustUseNativeMethods() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user space must use native methods:", this.mustUseNativeMethods_);
        }
        return this.mustUseNativeMethods_;
    }

    public int read(byte[] byArray, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("dataBuffer");
        }
        return this.read(byArray, n, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n4;
        if (byArray == null) {
            throw new NullPointerException("dataBuffer");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("dataBuffer.length (" + byArray.length + ")", 1);
        }
        if (n < 0 || n > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("userSpaceOffset (" + n + ")", 4);
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ExtendedIllegalArgumentException("dataOffset (" + n2 + ")", 4);
        }
        if (n3 < 0 || n3 > byArray.length - n2) {
            throw new ExtendedIllegalArgumentException("length (" + n3 + ")", 4);
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.nativeReadWriteImpl_ != null) {
            n4 = this.nativeReadWriteImpl_.read(byArray, n, n2, n3);
        } else {
            this.chooseImpl();
            n4 = this.impl_.read(byArray, n, n2, n3);
        }
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(2);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n2 <= 0) {
            throw new ExtendedIllegalArgumentException("length (" + n2 + ")", 4);
        }
        byte[] byArray = new byte[n2];
        this.read(byArray, n, 0, n2);
        if (this.dataConverter_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.dataConverter_ == null) {
                    this.dataConverter_ = new Converter(this.system_.getCcsid(), this.system_);
                }
            }
        }
        return this.dataConverter_.byteArrayToString(byArray);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeUserSpaceListener(UserSpaceListener userSpaceListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing user space listener.");
        }
        if (userSpaceListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.userSpaceListeners_ != null) {
            this.userSpaceListeners_.removeElement(userSpaceListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAutoExtendible(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.chooseImpl();
        this.impl_.setAutoExtendible(bl);
    }

    public void setInitialValue(byte by) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.chooseImpl();
        this.impl_.setInitialValue(by);
    }

    public void setLength(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (n < 1 || n > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 4);
        }
        this.chooseImpl();
        this.impl_.setLength(n);
    }

    public void setMustUseProgramCall(boolean bl) {
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'mustUseProgramCall' after connect.");
            throw new ExtendedIllegalStateException("mustUseProgramCall", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.mustUseProgramCall_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.mustUseProgramCall_);
            Boolean bl3 = new Boolean(bl);
            this.mustUseProgramCall_ = bl;
            this.propertyChangeListeners_.firePropertyChange("mustUseProgramCall", bl2, bl3);
        }
    }

    public void setMustUseNativeMethods(boolean bl) throws UnsupportedEncodingException, CharConversionException, UnsatisfiedLinkError, SecurityException {
        if (this.propertyChangeListeners_ == null) {
            this.mustUseNativeMethods_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.mustUseNativeMethods_);
            Boolean bl3 = new Boolean(bl);
            this.mustUseNativeMethods_ = bl;
            this.propertyChangeListeners_.firePropertyChange("mustUseNativeMethods", bl2, bl3);
        }
        if (bl) {
            if (this.nativeReadWriteImpl_ == null) {
                this.nativeReadWriteImpl_ = new UserSpaceNativeReadWriteImplILE(this.system_);
                this.nativeReadWriteImpl_.open(this.library_, this.name_);
            }
        } else if (this.nativeReadWriteImpl_ != null) {
            this.nativeReadWriteImpl_.close();
            this.nativeReadWriteImpl_ = null;
        }
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "USRSPC");
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException("path", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.path_ = string;
        } else {
            String string2 = this.path_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", string2, string3);
            }
            this.library_ = qSYSObjectPathName.getLibraryName();
            this.name_ = qSYSObjectPathName.getObjectName();
            this.path_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", string2, string3);
            }
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS4003;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    public void write(byte[] byArray, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("dataBuffer");
        }
        this.write(byArray, n, 0, byArray.length, 0);
    }

    public void write(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.write(byArray, n, n2, n3, 0);
    }

    public void write(byte[] byArray, int n, int n2, int n3, int n4) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null) {
            throw new NullPointerException("dataBuffer");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("dataBuffer.length (" + byArray.length + ")", 1);
        }
        if (n < 0 || n > 0xFFFE00) {
            throw new ExtendedIllegalArgumentException("userSpaceOffset (" + n + ")", 4);
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ExtendedIllegalArgumentException("dataOffset (" + n2 + ")", 4);
        }
        if (n3 < 0 || n3 > byArray.length - n2) {
            throw new ExtendedIllegalArgumentException("length (" + n3 + ")", 4);
        }
        if (n + n3 >= 0xFFFE00) {
            Trace.log(2, "Request is not supported, causes space overflow.");
            throw new ExtendedIllegalArgumentException("userSpaceOffset + length (" + n + " + " + n3 + ")", 2);
        }
        if (n4 < 0 || n4 > 2) {
            throw new ExtendedIllegalArgumentException("forceAuxiliary (" + n4 + ")", 2);
        }
        if (this.nativeReadWriteImpl_ != null) {
            this.nativeReadWriteImpl_.write(byArray, n, n2, n3, n4);
        } else {
            this.chooseImpl();
            this.impl_.write(byArray, n, n2, n3, n4);
        }
        if (this.userSpaceListeners_ != null) {
            this.fireUserSpaceEvent(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("data");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("data (" + string + ")", 1);
        }
        this.chooseImpl();
        if (this.dataConverter_ == null) {
            UserSpace userSpace = this;
            synchronized (userSpace) {
                if (this.dataConverter_ == null) {
                    this.dataConverter_ = new Converter(this.system_.getCcsid(), this.system_);
                }
            }
        }
        this.write(this.dataConverter_.stringToByteArray(string), n);
    }

    public void setMustUseSockets(boolean bl) {
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'mustUseSockets' after connect.");
            throw new ExtendedIllegalStateException("mustUseSockets", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.mustUseSockets_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.mustUseSockets_);
            Boolean bl3 = new Boolean(bl);
            this.mustUseSockets_ = bl;
            this.propertyChangeListeners_.firePropertyChange("mustUseSockets", bl2, bl3);
        }
    }

    public boolean isMustUseSockets() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if must use sockets:", this.mustUseSockets_);
        }
        return this.mustUseSockets_;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

