/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class DDMASPReplyDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    DDMASPReplyDataStream() {
    }

    boolean checkReply() {
        if (this.getCodePoint() != 4683) {
            Trace.log(2, "DDM ASP failed with code point:", this.data_, 8, 2);
            return false;
        }
        return true;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving DDM ASP reply...");
        }
        if (this.readFromStream(inputStream, byArray = new byte[6], 0, 6) < 6) {
            Trace.log(2, "Failed to read all of the DDM ASP Reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToUnsignedShort(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 6);
        this.readAfterHeader(inputStream);
    }
}

