/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBColumnDescriptorsDataFormat;
import com.ibm.as400.access.SQLConversionSettings;
import java.sql.SQLException;

class DBExtendedColumnDescriptors {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;

    public DBExtendedColumnDescriptors(byte[] byArray, int n) {
        this.data_ = byArray;
        this.offset_ = n;
    }

    public int getAttributeBitmap(int n) {
        return BinaryConverter.byteArrayToShort(this.data_, this.offset_ + this.getExtendedColumnDescriptorOffset(n));
    }

    public DBColumnDescriptorsDataFormat getColumnDescriptors(int n, SQLConversionSettings sQLConversionSettings) throws SQLException {
        int n2 = this.getVariableColumnInfoLength(n);
        if (n2 > 0) {
            int n3 = this.getVariableColumnInfoOffset(n);
            DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat = new DBColumnDescriptorsDataFormat(sQLConversionSettings);
            dBColumnDescriptorsDataFormat.overlay(this.data_, this.offset_ - 6 + n3, n2);
            return dBColumnDescriptorsDataFormat;
        }
        return null;
    }

    public DBColumnDescriptorsDataFormat getColumnDescriptors(int n, ConvTable convTable, SQLConversionSettings sQLConversionSettings) throws SQLException {
        if (n <= this.getNumberOfColumns()) {
            int n2 = this.getVariableColumnInfoLength(n);
            if (n2 > 0) {
                int n3 = this.getVariableColumnInfoOffset(n);
                DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat = new DBColumnDescriptorsDataFormat(convTable.getCcsid(), sQLConversionSettings);
                dBColumnDescriptorsDataFormat.overlay(this.data_, this.offset_ - 6 + n3, n2);
                return dBColumnDescriptorsDataFormat;
            }
            return null;
        }
        return null;
    }

    private int getExtendedColumnDescriptorOffset(int n) {
        return (n - 1) * 16 + 10;
    }

    private int getVariableColumnInfoLength(int n) {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getExtendedColumnDescriptorOffset(n) + 8);
    }

    private int getVariableColumnInfoOffset(int n) {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + this.getExtendedColumnDescriptorOffset(n) + 4);
    }

    int getNumberOfColumns() {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_);
    }

    byte getSearchable(int n) {
        return this.data_[this.offset_ + this.getExtendedColumnDescriptorOffset(n) + 1];
    }

    byte getUpdateable(int n) {
        return this.data_[this.offset_ + this.getExtendedColumnDescriptorOffset(n)];
    }
}

