/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sort.SortRowsMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.CheckBoxVar;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SortRowsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SortRowsMeta.class;
    private TextVar wSortDir;
    private Text wPrefix;
    private TextVar wSortSize;
    private TextVar wFreeMemory;
    private CheckBoxVar wCompress;
    private Button wUniqueRows;
    private TableView wFields;
    private final SortRowsMeta input;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public SortRowsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (SortRowsMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        SortRowsDialog sortRowsDialog = this;
        int margin = sortRowsDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlSortDir = new Label((Composite)this.shell, 131072);
        wlSortDir.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.SortDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSortDir);
        FormData fdlSortDir = new FormData();
        fdlSortDir.left = new FormAttachment(0, 0);
        fdlSortDir.right = new FormAttachment(middle, -margin);
        fdlSortDir.top = new FormAttachment((Control)this.wTransformName, margin);
        wlSortDir.setLayoutData((Object)fdlSortDir);
        Button wbSortDir = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSortDir);
        wbSortDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSortDir = new FormData();
        fdbSortDir.right = new FormAttachment(100, 0);
        fdbSortDir.top = new FormAttachment((Control)this.wTransformName, margin);
        wbSortDir.setLayoutData((Object)fdbSortDir);
        this.wSortDir = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSortDir);
        this.wSortDir.addModifyListener(lsMod);
        FormData fdSortDir = new FormData();
        fdSortDir.left = new FormAttachment(middle, 0);
        fdSortDir.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSortDir.right = new FormAttachment((Control)wbSortDir, -margin);
        this.wSortDir.setLayoutData((Object)fdSortDir);
        this.wSortDir.addModifyListener(e -> this.wSortDir.setToolTipText(this.variables.resolve(this.wSortDir.getText())));
        wbSortDir.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wSortDir, (IVariables)this.variables));
        Label wlPrefix = new Label((Composite)this.shell, 131072);
        wlPrefix.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.Prefix.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrefix);
        FormData fdlPrefix = new FormData();
        fdlPrefix.left = new FormAttachment(0, 0);
        fdlPrefix.right = new FormAttachment(middle, -margin);
        fdlPrefix.top = new FormAttachment((Control)wbSortDir, margin * 2);
        wlPrefix.setLayoutData((Object)fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        FormData fdPrefix = new FormData();
        fdPrefix.left = new FormAttachment(middle, 0);
        fdPrefix.top = new FormAttachment((Control)wbSortDir, margin * 2);
        fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)fdPrefix);
        this.wPrefix.setText("srt");
        Label wlSortSize = new Label((Composite)this.shell, 131072);
        wlSortSize.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.SortSize.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSortSize);
        FormData fdlSortSize = new FormData();
        fdlSortSize.left = new FormAttachment(0, 0);
        fdlSortSize.right = new FormAttachment(middle, -margin);
        fdlSortSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        wlSortSize.setLayoutData((Object)fdlSortSize);
        this.wSortSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSortSize);
        this.wSortSize.addModifyListener(lsMod);
        FormData fdSortSize = new FormData();
        fdSortSize.left = new FormAttachment(middle, 0);
        fdSortSize.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        fdSortSize.right = new FormAttachment(100, 0);
        this.wSortSize.setLayoutData((Object)fdSortSize);
        Label wlFreeMemory = new Label((Composite)this.shell, 131072);
        wlFreeMemory.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.FreeMemory.Label", (String[])new String[0]));
        wlFreeMemory.setToolTipText(BaseMessages.getString(PKG, (String)"SortRowsDialog.FreeMemory.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFreeMemory);
        FormData fdlFreeMemory = new FormData();
        fdlFreeMemory.left = new FormAttachment(0, 0);
        fdlFreeMemory.right = new FormAttachment(middle, -margin);
        fdlFreeMemory.top = new FormAttachment((Control)this.wSortSize, margin * 2);
        wlFreeMemory.setLayoutData((Object)fdlFreeMemory);
        this.wFreeMemory = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wFreeMemory.setToolTipText(BaseMessages.getString(PKG, (String)"SortRowsDialog.FreeMemory.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFreeMemory);
        this.wFreeMemory.addModifyListener(lsMod);
        FormData fdFreeMemory = new FormData();
        fdFreeMemory.left = new FormAttachment(middle, 0);
        fdFreeMemory.top = new FormAttachment((Control)this.wSortSize, margin * 2);
        fdFreeMemory.right = new FormAttachment(100, 0);
        this.wFreeMemory.setLayoutData((Object)fdFreeMemory);
        Label wlCompress = new Label((Composite)this.shell, 131072);
        wlCompress.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.Compress.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCompress);
        FormData fdlCompress = new FormData();
        fdlCompress.left = new FormAttachment(0, 0);
        fdlCompress.right = new FormAttachment(middle, -margin);
        fdlCompress.top = new FormAttachment((Control)this.wFreeMemory, margin * 2);
        wlCompress.setLayoutData((Object)fdlCompress);
        this.wCompress = new CheckBoxVar(this.variables, (Composite)this.shell, 32, "");
        PropsUi.setLook((Widget)this.wCompress);
        FormData fdCompress = new FormData();
        fdCompress.left = new FormAttachment(middle, 0);
        fdCompress.top = new FormAttachment((Control)wlCompress, 0, 0x1000000);
        fdCompress.right = new FormAttachment(100, 0);
        this.wCompress.setLayoutData((Object)fdCompress);
        this.wCompress.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SortRowsDialog.this.log.logDetailed("SortRowsDialog", new Object[]{"Selection Listener for compress: " + SortRowsDialog.this.wCompress.getSelection()});
                SortRowsDialog.this.input.setChanged();
            }
        });
        Label wlUniqueRows = new Label((Composite)this.shell, 131072);
        wlUniqueRows.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.UniqueRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUniqueRows);
        FormData fdlUniqueRows = new FormData();
        fdlUniqueRows.left = new FormAttachment(0, 0);
        fdlUniqueRows.right = new FormAttachment(middle, -margin);
        fdlUniqueRows.top = new FormAttachment((Control)this.wCompress, margin);
        wlUniqueRows.setLayoutData((Object)fdlUniqueRows);
        this.wUniqueRows = new Button((Composite)this.shell, 32);
        this.wUniqueRows.setToolTipText(BaseMessages.getString(PKG, (String)"SortRowsDialog.UniqueRows.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUniqueRows);
        FormData fdUniqueRows = new FormData();
        fdUniqueRows.left = new FormAttachment(middle, 0);
        fdUniqueRows.top = new FormAttachment((Control)wlUniqueRows, 0, 0x1000000);
        fdUniqueRows.right = new FormAttachment(100, 0);
        this.wUniqueRows.setLayoutData((Object)fdUniqueRows);
        this.wUniqueRows.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SortRowsDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wUniqueRows, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.getFieldName().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.Ascending.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.CaseInsensitive.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.CollatorDisabled.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.CollatorStrength.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Primary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Secondary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Tertiary", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Identical", (String[])new String[0])}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SortRowsDialog.PreSortedField.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSortDir.setText(this.input.getDirectory());
        }
        this.wSortSize.setText(Const.NVL((String)this.input.getSortSize(), (String)""));
        this.wFreeMemory.setText(Const.NVL((String)this.input.getFreeMemoryLimit(), (String)""));
        this.wCompress.setSelection(this.input.getCompressFiles());
        this.wCompress.setVariableName(this.input.getCompressFilesVariable());
        this.wUniqueRows.setSelection(this.input.isOnlyPassingUniqueRows());
        Table table = this.wFields.table;
        if (this.input.getFieldName().length > 0) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.input.getFieldName()[i]);
            ti.setText(2, this.input.getAscending()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            ti.setText(3, this.input.getCaseSensitive()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            ti.setText(4, this.input.getCollatorEnabled()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            ti.setText(5, this.input.getCollatorStrength()[i] == 0 ? BaseMessages.getString(PKG, (String)"System.Combo.Primary", (String[])new String[0]) : Integer.toString(this.input.getCollatorStrength()[i]));
            ti.setText(6, this.input.getPreSortedField()[i] ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setPrefix(this.wPrefix.getText());
        this.input.setDirectory(this.wSortDir.getText());
        this.input.setSortSize(this.wSortSize.getText());
        this.input.setFreeMemoryLimit(this.wFreeMemory.getText());
        this.log.logDetailed("Sort rows", new Object[]{"Compression is set to " + this.wCompress.getSelection()});
        this.input.setCompressFiles(this.wCompress.getSelection());
        this.input.setCompressFilesVariable(this.wCompress.getVariableName());
        this.input.setOnlyPassingUniqueRows(this.wUniqueRows.getSelection());
        int nrFields = this.wFields.nrNonEmpty();
        this.input.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
            this.input.getAscending()[i] = Utils.isEmpty((CharSequence)ti.getText(2)) || BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(2));
            this.input.getCaseSensitive()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(3));
            this.input.getCollatorEnabled()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(4));
            this.input.getCollatorStrength()[i] = ti.getText(5) == "" ? Integer.parseInt(BaseMessages.getString(PKG, (String)"System.Combo.Primary", (String[])new String[0])) : Integer.parseInt(ti.getText(5));
            this.input.getPreSortedField()[i] = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(ti.getText(6));
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener insertListener = (tableItem, v) -> {
                    tableItem.setText(2, BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]));
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)insertListener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

