/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.debug.transform.TransformDebugLevel;
import org.apache.hop.debug.transform.TransformDebugLevelDialog;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.extension.HopGuiPipelineGraphExtension;

@ExtensionPoint(id="EditTransformDebugLevelExtensionPoint", extensionPointId="PipelineGraphMouseUp", description="Edit the custom transform debug level with a single click")
public class EditTransformDebugLevelExtensionPoint
implements IExtensionPoint<HopGuiPipelineGraphExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiPipelineGraphExtension ext) throws HopException {
        try {
            if (ext.getAreaOwner() == null || ext.getAreaOwner().getOwner() == null) {
                return;
            }
            if (!(ext.getAreaOwner().getOwner() instanceof TransformDebugLevel)) {
                return;
            }
            TransformDebugLevel debugLevel = (TransformDebugLevel)ext.getAreaOwner().getOwner();
            PipelineMeta pipelineMeta = ext.getPipelineGraph().getPipelineMeta();
            TransformMeta transformMeta = (TransformMeta)ext.getAreaOwner().getParent();
            IRowMeta inputRowMeta = pipelineMeta.getPrevTransformFields(variables, transformMeta);
            TransformDebugLevelDialog dialog = new TransformDebugLevelDialog(HopGui.getInstance().getShell(), debugLevel, inputRowMeta);
            if (dialog.open()) {
                DebugLevelUtil.storeTransformDebugLevel((Map)pipelineMeta.getAttributesMap().get("debug_plugin"), transformMeta.getName(), debugLevel);
                ext.getPipelineGraph().redraw();
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error editing transform debugging level", e);
        }
    }
}

