/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xslt;

import java.io.File;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xslt.Xslt;
import org.apache.hop.pipeline.transforms.xml.xslt.XsltData;
import org.w3c.dom.Node;

@Transform(id="XSLT", image="XSLT.svg", name="i18n::XSLT.name", description="i18n::XSLT.description", categoryDescription="i18n::XSLT.category", keywords={"i18n::XsltMeta.keyword"}, documentationUrl="/pipeline/transforms/xslt.html")
public class XsltMeta
extends BaseTransformMeta<Xslt, XsltData> {
    private static final Class<?> PKG = XsltMeta.class;
    public static final String[] outputProperties = new String[]{"method", "version", "encoding", "standalone", "indent", "omit-xml-declaration", "doctype-public", "doctype-system", "media-type"};
    private String xslFilename;
    private String fieldName;
    private String resultFieldname;
    private String xslFileField;
    private boolean xslFileFieldUse;
    private boolean xslFieldIsAFile;
    private String xslFactory;
    private String[] outputPropertyName;
    private String[] outputPropertyValue;
    private String[] parameterName;
    private String[] parameterField;

    public String[] getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String[] argumentDirection) {
        this.parameterName = argumentDirection;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] argumentDirection) {
        this.parameterField = argumentDirection;
    }

    public String getXslFilename() {
        return this.xslFilename;
    }

    public String[] getOutputPropertyName() {
        return this.outputPropertyName;
    }

    public void setOutputPropertyName(String[] argumentDirection) {
        this.outputPropertyName = argumentDirection;
    }

    public String[] getOutputPropertyValue() {
        return this.outputPropertyValue;
    }

    public void setOutputPropertyValue(String[] argumentDirection) {
        this.outputPropertyValue = argumentDirection;
    }

    public void setXSLFileField(String xslfilefieldin) {
        this.xslFileField = xslfilefieldin;
    }

    public void setXSLFactory(String xslfactoryin) {
        this.xslFactory = xslfactoryin;
    }

    public String getXSLFactory() {
        return this.xslFactory;
    }

    public String getXSLFileField() {
        return this.xslFileField;
    }

    public String getResultfieldname() {
        return this.resultFieldname;
    }

    public String getFieldname() {
        return this.fieldName;
    }

    public void setXslFilename(String xslFilename) {
        this.xslFilename = xslFilename;
    }

    public void setResultfieldname(String resultfield) {
        this.resultFieldname = resultfield;
    }

    public void setFieldname(String fieldnamein) {
        this.fieldName = fieldnamein;
    }

    public void allocate(int nrParameters, int outputProps) {
        this.parameterName = new String[nrParameters];
        this.parameterField = new String[nrParameters];
        this.outputPropertyName = new String[outputProps];
        this.outputPropertyValue = new String[outputProps];
    }

    public Object clone() {
        int i;
        XsltMeta retval = (XsltMeta)((Object)super.clone());
        int nrparams = this.parameterName.length;
        int nroutputprops = this.outputPropertyName.length;
        retval.allocate(nrparams, nroutputprops);
        for (i = 0; i < nrparams; ++i) {
            retval.parameterName[i] = this.parameterName[i];
            retval.parameterField[i] = this.parameterField[i];
        }
        for (i = 0; i < nroutputprops; ++i) {
            retval.outputPropertyName[i] = this.outputPropertyName[i];
            retval.outputPropertyValue[i] = this.outputPropertyValue[i];
        }
        return retval;
    }

    public boolean useXSLField() {
        return this.xslFileFieldUse;
    }

    public void setXSLField(boolean value) {
        this.xslFileFieldUse = value;
    }

    public void setXSLFieldIsAFile(boolean xslFieldisAFile) {
        this.xslFieldIsAFile = xslFieldisAFile;
    }

    public boolean isXSLFieldIsAFile() {
        return this.xslFieldIsAFile;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node anode;
            int i;
            this.xslFilename = XmlHandler.getTagValue((Node)transformNode, (String)"xslfilename");
            this.fieldName = XmlHandler.getTagValue((Node)transformNode, (String)"fieldname");
            this.resultFieldname = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
            this.xslFileField = XmlHandler.getTagValue((Node)transformNode, (String)"xslfilefield");
            this.xslFileFieldUse = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"xslfilefielduse"));
            String isAFile = XmlHandler.getTagValue((Node)transformNode, (String)"xslfieldisafile");
            this.xslFieldIsAFile = this.xslFileFieldUse && Utils.isEmpty((CharSequence)isAFile) ? true : "Y".equalsIgnoreCase(isAFile);
            this.xslFactory = XmlHandler.getTagValue((Node)transformNode, (String)"xslfactory");
            Node parametersNode = XmlHandler.getSubNode((Node)transformNode, (String)"parameters");
            int nrparams = XmlHandler.countNodes((Node)parametersNode, (String)"parameter");
            Node parametersOutputProps = XmlHandler.getSubNode((Node)transformNode, (String)"outputproperties");
            int nroutputprops = XmlHandler.countNodes((Node)parametersOutputProps, (String)"outputproperty");
            this.allocate(nrparams, nroutputprops);
            for (i = 0; i < nrparams; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameterField[i] = XmlHandler.getTagValue((Node)anode, (String)"field");
                this.parameterName[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
            }
            for (i = 0; i < nroutputprops; ++i) {
                anode = XmlHandler.getSubNodeByNr((Node)parametersOutputProps, (String)"outputproperty", (int)i);
                this.outputPropertyName[i] = XmlHandler.getTagValue((Node)anode, (String)"name");
                this.outputPropertyValue[i] = XmlHandler.getTagValue((Node)anode, (String)"value");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"XsltMeta.Exception.UnableToLoadTransformInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int i;
        this.xslFilename = null;
        this.fieldName = null;
        this.resultFieldname = "result";
        this.xslFactory = "JAXP";
        this.xslFileField = null;
        this.xslFileFieldUse = false;
        this.xslFieldIsAFile = true;
        int nrparams = 0;
        int nroutputproperties = 0;
        this.allocate(nrparams, nroutputproperties);
        for (i = 0; i < nrparams; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterName[i] = "param";
        }
        for (i = 0; i < nroutputproperties; ++i) {
            this.outputPropertyName[i] = "outputprop" + i;
            this.outputPropertyValue[i] = "outputprop";
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v = new ValueMetaString(variables.resolve(this.getResultfieldname()));
        v.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)v);
    }

    public String getXml() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XmlHandler.addTagValue((String)"xslfilename", (String)this.xslFilename));
        retval.append("    " + XmlHandler.addTagValue((String)"fieldname", (String)this.fieldName));
        retval.append("    " + XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultFieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"xslfilefield", (String)this.xslFileField));
        retval.append("    " + XmlHandler.addTagValue((String)"xslfilefielduse", (boolean)this.xslFileFieldUse));
        retval.append("    " + XmlHandler.addTagValue((String)"xslfieldisafile", (boolean)this.xslFieldIsAFile));
        retval.append("    " + XmlHandler.addTagValue((String)"xslfactory", (String)this.xslFactory));
        retval.append("    <parameters>").append(Const.CR);
        for (i = 0; i < this.parameterName.length; ++i) {
            retval.append("      <parameter>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"field", (String)this.parameterField[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.parameterName[i]));
            retval.append("      </parameter>").append(Const.CR);
        }
        retval.append("    </parameters>").append(Const.CR);
        retval.append("    <outputproperties>").append(Const.CR);
        for (i = 0; i < this.outputPropertyName.length; ++i) {
            retval.append("      <outputproperty>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.outputPropertyName[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"value", (String)this.outputPropertyValue[i]));
            retval.append("      </outputproperty>").append(Const.CR);
        }
        retval.append("    </outputproperties>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ConnectedTransformOK", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getResultfieldname() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorResultFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.xslFileFieldUse) {
            if (this.getXSLFileField() == null) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorResultXSLFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorResultXSLFieldNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else if (this.xslFilename == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ErrorXSLFileNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            String realFilename = variables.resolve(this.xslFilename);
            File f = new File(realFilename);
            if (f.exists()) {
                if (f.isFile()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.FileExists", (String[])new String[]{realFilename}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.ExistsButNoFile", (String[])new String[]{realFilename}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"XsltMeta.CheckResult.FileNotExists", (String[])new String[]{realFilename}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

