/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.triggers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.CassandraException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.triggers.CustomClassLoader;
import org.apache.cassandra.triggers.ITrigger;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;

public class TriggerExecutor {
    public static final TriggerExecutor instance = new TriggerExecutor();
    private final Map<String, ITrigger> cachedTriggers = Maps.newConcurrentMap();
    private final ClassLoader parent = Thread.currentThread().getContextClassLoader();
    private volatile ClassLoader customClassLoader;

    private TriggerExecutor() {
        this.reloadClasses();
    }

    public void reloadClasses() {
        File triggerDirectory = FBUtilities.cassandraTriggerDir();
        if (triggerDirectory == null) {
            return;
        }
        this.customClassLoader = new CustomClassLoader(this.parent, triggerDirectory);
        this.cachedTriggers.clear();
    }

    public PartitionUpdate execute(PartitionUpdate updates) throws InvalidRequestException {
        List<Mutation> intermediate = this.executeInternal(updates);
        if (intermediate == null || intermediate.isEmpty()) {
            return updates;
        }
        List<PartitionUpdate> augmented = this.validateForSinglePartition(updates.metadata().id, updates.partitionKey(), intermediate);
        augmented.add(updates);
        return PartitionUpdate.merge(augmented);
    }

    public Collection<Mutation> execute(Collection<? extends IMutation> mutations) throws InvalidRequestException {
        boolean hasCounters = false;
        LinkedList<Mutation> augmentedMutations = null;
        for (IMutation iMutation : mutations) {
            if (iMutation instanceof CounterMutation) {
                hasCounters = true;
            }
            for (PartitionUpdate upd : iMutation.getPartitionUpdates()) {
                List<Mutation> augmentations = this.executeInternal(upd);
                if (augmentations == null || augmentations.isEmpty()) continue;
                this.validate(augmentations);
                if (augmentedMutations == null) {
                    augmentedMutations = new LinkedList<Mutation>();
                }
                augmentedMutations.addAll(augmentations);
            }
        }
        if (augmentedMutations == null) {
            return null;
        }
        if (hasCounters) {
            throw new InvalidRequestException("Counter mutations and trigger mutations cannot be applied together atomically.");
        }
        Collection<? extends IMutation> originalMutations = mutations;
        return this.mergeMutations(Iterables.concat(originalMutations, augmentedMutations));
    }

    private Collection<Mutation> mergeMutations(Iterable<Mutation> mutations) {
        ArrayListMultimap groupedMutations = ArrayListMultimap.create();
        for (Mutation mutation : mutations) {
            Pair key = Pair.create(mutation.getKeyspaceName(), mutation.key().getKey());
            groupedMutations.put(key, (Object)mutation);
        }
        ArrayList<Mutation> merged = new ArrayList<Mutation>(groupedMutations.size());
        for (Pair key : groupedMutations.keySet()) {
            merged.add(Mutation.merge(groupedMutations.get((Object)key)));
        }
        return merged;
    }

    private List<PartitionUpdate> validateForSinglePartition(TableId tableId, DecoratedKey key, Collection<Mutation> tmutations) throws InvalidRequestException {
        this.validate(tmutations);
        if (tmutations.size() == 1) {
            ArrayList updates = Lists.newArrayList(((Mutation)Iterables.getOnlyElement(tmutations)).getPartitionUpdates());
            if (updates.size() > 1) {
                throw new InvalidRequestException("The updates generated by triggers are not all for the same partition");
            }
            this.validateSamePartition(tableId, key, (PartitionUpdate)Iterables.getOnlyElement((Iterable)updates));
            return updates;
        }
        ArrayList<PartitionUpdate> updates = new ArrayList<PartitionUpdate>(tmutations.size());
        for (Mutation mutation : tmutations) {
            for (PartitionUpdate update : mutation.getPartitionUpdates()) {
                this.validateSamePartition(tableId, key, update);
                updates.add(update);
            }
        }
        return updates;
    }

    private void validateSamePartition(TableId tableId, DecoratedKey key, PartitionUpdate update) throws InvalidRequestException {
        if (!key.equals(update.partitionKey())) {
            throw new InvalidRequestException("Partition key of additional mutation does not match primary update key");
        }
        if (!tableId.equals(update.metadata().id)) {
            throw new InvalidRequestException("table of additional mutation does not match primary update table");
        }
    }

    private void validate(Collection<Mutation> tmutations) throws InvalidRequestException {
        for (Mutation mutation : tmutations) {
            QueryProcessor.validateKey(mutation.key().getKey());
            for (PartitionUpdate update : mutation.getPartitionUpdates()) {
                update.validate();
            }
        }
    }

    private List<Mutation> executeInternal(PartitionUpdate update) {
        Triggers triggers = update.metadata().triggers;
        if (triggers.isEmpty()) {
            return null;
        }
        LinkedList tmutations = Lists.newLinkedList();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            for (TriggerMetadata td : triggers) {
                Collection<Mutation> temp;
                ITrigger trigger = this.cachedTriggers.get(td.classOption);
                if (trigger == null) {
                    trigger = this.loadTriggerInstance(td.classOption);
                    this.cachedTriggers.put(td.classOption, trigger);
                }
                if ((temp = trigger.augment(update)) == null) continue;
                tmutations.addAll(temp);
            }
            LinkedList linkedList = tmutations;
            return linkedList;
        }
        catch (CassandraException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception while executing trigger on table with ID: %s", update.metadata().id), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.parent);
        }
    }

    public synchronized ITrigger loadTriggerInstance(String triggerClass) throws Exception {
        if (this.cachedTriggers.get(triggerClass) != null) {
            return this.cachedTriggers.get(triggerClass);
        }
        return (ITrigger)this.customClassLoader.loadClass(triggerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

