/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import com.codahale.metrics.Snapshot;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.reads.AlwaysSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.FixedSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.HybridSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.NeverSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.PercentileSpeculativeRetryPolicy;

public interface SpeculativeRetryPolicy {
    public long calculateThreshold(Snapshot var1, long var2);

    public Kind kind();

    public static SpeculativeRetryPolicy fromString(String str) {
        if (AlwaysSpeculativeRetryPolicy.stringMatches(str)) {
            return AlwaysSpeculativeRetryPolicy.INSTANCE;
        }
        if (NeverSpeculativeRetryPolicy.stringMatches(str)) {
            return NeverSpeculativeRetryPolicy.INSTANCE;
        }
        if (PercentileSpeculativeRetryPolicy.stringMatches(str)) {
            return PercentileSpeculativeRetryPolicy.fromString(str);
        }
        if (FixedSpeculativeRetryPolicy.stringMatches(str)) {
            return FixedSpeculativeRetryPolicy.fromString(str);
        }
        if (HybridSpeculativeRetryPolicy.stringMatches(str)) {
            return HybridSpeculativeRetryPolicy.fromString(str);
        }
        throw new ConfigurationException(String.format("Invalid value %s for option '%s'", new Object[]{str, TableParams.Option.SPECULATIVE_RETRY}));
    }

    public static enum Kind {
        NEVER,
        FIXED,
        PERCENTILE,
        HYBRID,
        ALWAYS;

    }
}

