/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.transport.ProtocolVersion;

abstract class AbstractQueryPager<T extends ReadQuery>
implements QueryPager {
    protected final T query;
    protected final DataLimits limits;
    protected final ProtocolVersion protocolVersion;
    private final boolean enforceStrictLiveness;
    private int remaining;
    private DecoratedKey lastKey;
    private int remainingInPartition;
    private boolean exhausted;

    protected AbstractQueryPager(T query, ProtocolVersion protocolVersion) {
        this.query = query;
        this.protocolVersion = protocolVersion;
        this.limits = query.limits();
        this.enforceStrictLiveness = query.metadata().enforceStrictLiveness();
        this.remaining = this.limits.count();
        this.remainingInPartition = this.limits.perPartitionCount();
    }

    @Override
    public ReadExecutionController executionController() {
        return this.query.executionController();
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) {
        if (this.isExhausted()) {
            return EmptyIterators.partition();
        }
        pageSize = Math.min(pageSize, this.remaining);
        RowPager pager = new RowPager(this.limits.forPaging(pageSize), this.query.nowInSec());
        T readQuery = this.nextPageReadQuery(pageSize);
        if (readQuery == null) {
            this.exhausted = true;
            return EmptyIterators.partition();
        }
        return Transformation.apply(readQuery.execute(consistency, clientState, queryStartNanoTime), pager);
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadExecutionController executionController) {
        if (this.isExhausted()) {
            return EmptyIterators.partition();
        }
        pageSize = Math.min(pageSize, this.remaining);
        RowPager pager = new RowPager(this.limits.forPaging(pageSize), this.query.nowInSec());
        T readQuery = this.nextPageReadQuery(pageSize);
        if (readQuery == null) {
            this.exhausted = true;
            return EmptyIterators.partition();
        }
        return Transformation.apply(readQuery.executeInternal(executionController), pager);
    }

    public UnfilteredPartitionIterator fetchPageUnfiltered(TableMetadata metadata, int pageSize, ReadExecutionController executionController) {
        if (this.isExhausted()) {
            return EmptyIterators.unfilteredPartition(metadata);
        }
        pageSize = Math.min(pageSize, this.remaining);
        UnfilteredPager pager = new UnfilteredPager(this.limits.forPaging(pageSize), this.query.nowInSec());
        T readQuery = this.nextPageReadQuery(pageSize);
        if (readQuery == null) {
            this.exhausted = true;
            return EmptyIterators.unfilteredPartition(metadata);
        }
        return Transformation.apply(readQuery.executeLocally(executionController), pager);
    }

    protected void restoreState(DecoratedKey lastKey, int remaining, int remainingInPartition) {
        this.lastKey = lastKey;
        this.remaining = remaining;
        this.remainingInPartition = remainingInPartition;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted || this.remaining == 0 || this instanceof SinglePartitionPager && this.remainingInPartition == 0;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    protected int remainingInPartition() {
        return this.remainingInPartition;
    }

    protected abstract T nextPageReadQuery(int var1);

    protected abstract void recordLast(DecoratedKey var1, Row var2);

    protected abstract boolean isPreviouslyReturnedPartition(DecoratedKey var1);

    private abstract class Pager<T extends Unfiltered>
    extends Transformation<BaseRowIterator<T>> {
        private final DataLimits pageLimits;
        protected final DataLimits.Counter counter;
        private DecoratedKey currentKey;
        private Row lastRow;
        private boolean isFirstPartition = true;

        private Pager(DataLimits pageLimits, int nowInSec) {
            this.counter = pageLimits.newCounter(nowInSec, true, AbstractQueryPager.this.query.selectsFullPartition(), AbstractQueryPager.this.enforceStrictLiveness);
            this.pageLimits = pageLimits;
        }

        @Override
        public BaseRowIterator<T> applyToPartition(BaseRowIterator<T> partition) {
            this.currentKey = partition.partitionKey();
            if (this.isFirstPartition) {
                this.isFirstPartition = false;
                if (AbstractQueryPager.this.isPreviouslyReturnedPartition(this.currentKey) && !partition.hasNext()) {
                    partition.close();
                    return null;
                }
            }
            return this.apply(partition);
        }

        protected abstract BaseRowIterator<T> apply(BaseRowIterator<T> var1);

        @Override
        public void onClose() {
            this.counter.onClose();
            AbstractQueryPager.this.recordLast(AbstractQueryPager.this.lastKey, this.lastRow);
            AbstractQueryPager.this.remaining = AbstractQueryPager.this.remaining - this.counter.counted();
            if (this.lastRow != null && (this.lastRow.clustering() == Clustering.STATIC_CLUSTERING || this.lastRow.clustering().isEmpty())) {
                AbstractQueryPager.this.remainingInPartition = 0;
            } else {
                AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.remainingInPartition - this.counter.countedInCurrentPartition();
            }
            AbstractQueryPager.this.exhausted = this.pageLimits.isExhausted(this.counter);
        }

        @Override
        public Row applyToStatic(Row row) {
            if (!row.isEmpty()) {
                if (!this.currentKey.equals(AbstractQueryPager.this.lastKey)) {
                    AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.limits.perPartitionCount();
                }
                AbstractQueryPager.this.lastKey = this.currentKey;
                this.lastRow = row;
            }
            return row;
        }

        @Override
        public Row applyToRow(Row row) {
            if (!this.currentKey.equals(AbstractQueryPager.this.lastKey)) {
                AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.limits.perPartitionCount();
                AbstractQueryPager.this.lastKey = this.currentKey;
            }
            this.lastRow = row;
            return row;
        }
    }

    private class RowPager
    extends Pager<Row> {
        private RowPager(DataLimits pageLimits, int nowInSec) {
            super(pageLimits, nowInSec);
        }

        @Override
        protected BaseRowIterator<Row> apply(BaseRowIterator<Row> partition) {
            return Transformation.apply(this.counter.applyTo((RowIterator)partition), this);
        }
    }

    private class UnfilteredPager
    extends Pager<Unfiltered> {
        private UnfilteredPager(DataLimits pageLimits, int nowInSec) {
            super(pageLimits, nowInSec);
        }

        @Override
        protected BaseRowIterator<Unfiltered> apply(BaseRowIterator<Unfiltered> partition) {
            return Transformation.apply(this.counter.applyTo((UnfilteredRowIterator)partition), this);
        }
    }
}

