/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Collectors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWriteResponseHandler<T>
implements RequestCallback<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractWriteResponseHandler.class);
    private AtomicInteger responsesAndExpirations;
    private final SimpleCondition condition = new SimpleCondition();
    protected final ReplicaPlan.ForTokenWrite replicaPlan;
    protected final Runnable callback;
    protected final WriteType writeType;
    private static final AtomicIntegerFieldUpdater<AbstractWriteResponseHandler> failuresUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractWriteResponseHandler.class, "failures");
    private volatile int failures = 0;
    private final Map<InetAddressAndPort, RequestFailureReason> failureReasonByEndpoint;
    private final long queryStartNanoTime;
    private AbstractWriteResponseHandler idealCLDelegate;
    private boolean requestedCLAchieved = false;

    protected AbstractWriteResponseHandler(ReplicaPlan.ForTokenWrite replicaPlan, Runnable callback, WriteType writeType, long queryStartNanoTime) {
        this.replicaPlan = replicaPlan;
        this.callback = callback;
        this.writeType = writeType;
        this.failureReasonByEndpoint = new ConcurrentHashMap<InetAddressAndPort, RequestFailureReason>();
        this.queryStartNanoTime = queryStartNanoTime;
    }

    public void get() throws WriteTimeoutException, WriteFailureException {
        boolean success;
        long timeoutNanos = this.currentTimeoutNanos();
        try {
            success = this.condition.await(timeoutNanos, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            int blockedFor = this.blockFor();
            int acks = this.ackCount();
            if (acks >= blockedFor) {
                acks = blockedFor - 1;
            }
            throw new WriteTimeoutException(this.writeType, this.replicaPlan.consistencyLevel(), acks, blockedFor);
        }
        if (this.blockFor() + this.failures > this.candidateReplicaCount()) {
            throw new WriteFailureException(this.replicaPlan.consistencyLevel(), this.ackCount(), this.blockFor(), this.writeType, this.failureReasonByEndpoint);
        }
    }

    public final long currentTimeoutNanos() {
        long requestTimeout = this.writeType == WriteType.COUNTER ? DatabaseDescriptor.getCounterWriteRpcTimeout(TimeUnit.NANOSECONDS) : DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS);
        return requestTimeout - (System.nanoTime() - this.queryStartNanoTime);
    }

    public void setIdealCLResponseHandler(AbstractWriteResponseHandler handler) {
        this.idealCLDelegate = handler;
        this.idealCLDelegate.responsesAndExpirations = new AtomicInteger(((EndpointsForToken)this.replicaPlan.contacts()).size());
    }

    protected final void logResponseToIdealCLDelegate(Message<T> m) {
        if (this.idealCLDelegate == null) {
            return;
        }
        if (this.idealCLDelegate == this) {
            this.decrementResponseOrExpired();
        } else {
            this.idealCLDelegate.onResponse(m);
        }
    }

    public final void expired() {
        if (this.idealCLDelegate == null) {
            return;
        }
        if (this.idealCLDelegate == this) {
            this.decrementResponseOrExpired();
        } else {
            this.idealCLDelegate.decrementResponseOrExpired();
        }
    }

    protected int blockFor() {
        return this.replicaPlan.blockFor();
    }

    protected int candidateReplicaCount() {
        if (this.replicaPlan.consistencyLevel().isDatacenterLocal()) {
            return Replicas.countInOurDc(this.replicaPlan.liveAndDown()).allReplicas();
        }
        return ((EndpointsForToken)this.replicaPlan.liveAndDown()).size();
    }

    public ConsistencyLevel consistencyLevel() {
        return this.replicaPlan.consistencyLevel();
    }

    protected boolean waitingFor(InetAddressAndPort from) {
        return true;
    }

    protected abstract int ackCount();

    @Override
    public abstract void onResponse(Message<T> var1);

    protected void signal() {
        if (this.idealCLDelegate != null) {
            this.idealCLDelegate.requestedCLAchieved = true;
        }
        this.condition.signalAll();
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        logger.trace("Got failure from {}", (Object)from);
        int n = this.waitingFor(from) ? failuresUpdater.incrementAndGet(this) : this.failures;
        this.failureReasonByEndpoint.put(from, failureReason);
        if (this.blockFor() + n > this.candidateReplicaCount()) {
            this.signal();
        }
    }

    @Override
    public boolean invokeOnFailure() {
        return true;
    }

    private final void decrementResponseOrExpired() {
        int decrementedValue = this.responsesAndExpirations.decrementAndGet();
        if (decrementedValue == 0) {
            if (!this.condition.isSignaled() && this.requestedCLAchieved) {
                this.replicaPlan.keyspace().metric.writeFailedIdealCL.inc();
            } else {
                this.replicaPlan.keyspace().metric.idealCLWriteLatency.addNano(System.nanoTime() - this.queryStartNanoTime);
            }
        }
    }

    public void maybeTryAdditionalReplicas(IMutation mutation, StorageProxy.WritePerformer writePerformer, String localDC) {
        EndpointsForToken uncontacted = (EndpointsForToken)this.replicaPlan.liveUncontacted();
        if (uncontacted.isEmpty()) {
            return;
        }
        long timeout = Long.MAX_VALUE;
        List cfs = mutation.getTableIds().stream().map(Schema.instance::getColumnFamilyStoreInstance).collect(Collectors.toList());
        for (ColumnFamilyStore cf : cfs) {
            timeout = Math.min(timeout, cf.additionalWriteLatencyNanos);
        }
        if (timeout > mutation.getTimeout(TimeUnit.NANOSECONDS)) {
            return;
        }
        try {
            if (!this.condition.await(timeout, TimeUnit.NANOSECONDS)) {
                for (ColumnFamilyStore cf : cfs) {
                    cf.metric.additionalWrites.inc();
                }
                writePerformer.apply(mutation, this.replicaPlan.withContact(uncontacted), this, localDC);
            }
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

