/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Int32Serializer
extends TypeSerializer<Integer> {
    public static final Int32Serializer instance = new Int32Serializer();

    @Override
    public <V> Integer deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : Integer.valueOf(accessor.toInt(value));
    }

    @Override
    public ByteBuffer serialize(Integer value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 4 && !accessor.isEmpty(value)) {
            throw new MarshalException(String.format("Expected 4 or 0 byte int (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Integer value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

