/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import org.apache.cassandra.hints.ChecksummedDataInput;
import org.apache.cassandra.hints.InputPosition;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.security.EncryptionUtils;
import org.apache.cassandra.utils.Throwables;

public class EncryptedChecksummedDataInput
extends ChecksummedDataInput {
    private static final FastThreadLocal<ByteBuffer> reusableBuffers = new FastThreadLocal<ByteBuffer>(){

        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(0);
        }
    };
    private final Cipher cipher;
    private final ICompressor compressor;
    private final EncryptionUtils.ChannelProxyReadChannel readChannel;
    private long sourcePosition;

    protected EncryptedChecksummedDataInput(ChannelProxy channel, Cipher cipher, ICompressor compressor, long filePosition) {
        super(channel);
        this.cipher = cipher;
        this.compressor = compressor;
        this.readChannel = new EncryptionUtils.ChannelProxyReadChannel(channel, filePosition);
        this.sourcePosition = filePosition;
        assert (cipher != null);
        assert (compressor != null);
    }

    @Override
    public boolean isEOF() {
        return this.readChannel.getCurrentPosition() == this.channel.size() && this.buffer.remaining() == 0;
    }

    @Override
    public long getSourcePosition() {
        return this.sourcePosition;
    }

    @Override
    public InputPosition getSeekPosition() {
        return new Position(this.sourcePosition, this.bufferOffset, this.buffer.position());
    }

    @Override
    public void seek(InputPosition p) {
        Position pos = (Position)p;
        this.bufferOffset = pos.bufferStart;
        this.readChannel.setPosition(pos.sourcePosition);
        this.buffer.position(0).limit(0);
        this.resetCrc();
        this.reBuffer();
        this.buffer.position(pos.bufferPosition);
        assert (this.sourcePosition == pos.sourcePosition);
        assert (this.bufferOffset == pos.bufferStart);
        assert (this.buffer.position() == pos.bufferPosition);
    }

    @Override
    protected void readBuffer() {
        this.sourcePosition = this.readChannel.getCurrentPosition();
        if (this.isEOF()) {
            return;
        }
        try {
            ByteBuffer byteBuffer = (ByteBuffer)reusableBuffers.get();
            ByteBuffer decrypted = EncryptionUtils.decrypt(this.readChannel, byteBuffer, true, this.cipher);
            this.buffer = EncryptionUtils.uncompress(decrypted, this.buffer, true, this.compressor);
            if (decrypted.capacity() > byteBuffer.capacity()) {
                reusableBuffers.set((Object)decrypted);
            }
        }
        catch (IOException ioe) {
            throw new FSReadError((Throwable)ioe, this.getPath());
        }
    }

    public static ChecksummedDataInput upgradeInput(ChecksummedDataInput input, Cipher cipher, ICompressor compressor) {
        long position = input.getPosition();
        input.close();
        ChannelProxy channel = new ChannelProxy(input.getPath());
        try {
            return new EncryptedChecksummedDataInput(channel, cipher, compressor, position);
        }
        catch (Throwable t) {
            throw Throwables.cleaned(channel.close(t));
        }
    }

    @VisibleForTesting
    Cipher getCipher() {
        return this.cipher;
    }

    @VisibleForTesting
    ICompressor getCompressor() {
        return this.compressor;
    }

    static class Position
    extends ChecksummedDataInput.Position {
        final long bufferStart;
        final int bufferPosition;

        public Position(long sourcePosition, long bufferStart, int bufferPosition) {
            super(sourcePosition);
            this.bufferStart = bufferStart;
            this.bufferPosition = bufferPosition;
        }

        @Override
        public long subtract(InputPosition o) {
            Position other = (Position)o;
            return this.bufferStart - other.bufferStart + (long)this.bufferPosition - (long)other.bufferPosition;
        }
    }
}

