/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import org.apache.cassandra.db.ArrayClustering;
import org.apache.cassandra.db.ArrayClusteringBound;
import org.apache.cassandra.db.ArrayClusteringBoundary;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.ArrayCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

class ByteArrayObjectFactory
implements ValueAccessor.ObjectFactory<byte[]> {
    private static final Clustering<byte[]> EMPTY_CLUSTERING = new ArrayClustering(new byte[0][]){

        @Override
        public String toString(TableMetadata metadata) {
            return "EMPTY";
        }
    };
    static final ValueAccessor.ObjectFactory<byte[]> instance = new ByteArrayObjectFactory();
    private static final ArrayClusteringBound BOTTOM_BOUND = new ArrayClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, new byte[0][]);
    private static final ArrayClusteringBound TOP_BOUND = new ArrayClusteringBound(ClusteringPrefix.Kind.INCL_END_BOUND, new byte[0][]);

    private ByteArrayObjectFactory() {
    }

    @Override
    public Cell<byte[]> cell(ColumnMetadata column, long timestamp, int ttl, int localDeletionTime, byte[] value, CellPath path) {
        return new ArrayCell(column, timestamp, ttl, localDeletionTime, value, path);
    }

    public Clustering<byte[]> clustering(byte[] ... values) {
        return new ArrayClustering(values);
    }

    @Override
    public Clustering<byte[]> clustering() {
        return EMPTY_CLUSTERING;
    }

    public ClusteringBound<byte[]> bound(ClusteringPrefix.Kind kind, byte[] ... values) {
        return new ArrayClusteringBound(kind, values);
    }

    @Override
    public ClusteringBound<byte[]> bound(ClusteringPrefix.Kind kind) {
        return kind.isStart() ? BOTTOM_BOUND : TOP_BOUND;
    }

    public ClusteringBoundary<byte[]> boundary(ClusteringPrefix.Kind kind, byte[] ... values) {
        return new ArrayClusteringBoundary(kind, values);
    }
}

