/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteArrayUtil;

public interface ClusteringPrefix<V>
extends IMeasurableMemory,
Clusterable<V> {
    public static final Serializer serializer = new Serializer();

    default public boolean isBottom() {
        return this.kind() == Kind.INCL_START_BOUND && this.size() == 0;
    }

    default public boolean isTop() {
        return this.kind() == Kind.INCL_END_BOUND && this.size() == 0;
    }

    public Kind kind();

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public V get(int var1);

    public ValueAccessor<V> accessor();

    default public ByteBuffer bufferAt(int i) {
        return this.accessor().toBuffer(this.get(i));
    }

    default public String stringAt(int i, ClusteringComparator comparator) {
        return comparator.subtype(i).getString(this.get(i), this.accessor());
    }

    default public void validate(int i, ClusteringComparator comparator) {
        comparator.subtype(i).validate(this.get(i), this.accessor());
    }

    default public void digest(Digest digest) {
        for (int i = 0; i < this.size(); ++i) {
            V value = this.get(i);
            if (value == null) continue;
            digest.update(value, this.accessor());
        }
        digest.updateWithByte(this.kind().ordinal());
    }

    default public int dataSize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            V v = this.get(i);
            size += v == null ? 0 : this.accessor().size(v);
        }
        return size;
    }

    public String toString(TableMetadata var1);

    default public ByteBuffer serializeAsPartitionKey() {
        if (this.size() == 1) {
            return this.accessor().toBuffer(this.get(0));
        }
        ByteBuffer[] values = new ByteBuffer[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = this.accessor().toBuffer(this.get(i));
        }
        return CompositeType.build(ByteBufferAccessor.instance, values);
    }

    public V[] getRawValues();

    public ByteBuffer[] getBufferArray();

    public ClusteringPrefix<V> minimize();

    public static <V> int hashCode(ClusteringPrefix<V> prefix) {
        int result = 31;
        for (int i = 0; i < prefix.size(); ++i) {
            result += 31 * prefix.accessor().hashCode(prefix.get(i));
        }
        return 31 * result + Objects.hashCode((Object)prefix.kind());
    }

    public static <V1, V2> boolean equals(ClusteringPrefix<V1> left, ClusteringPrefix<V2> right) {
        if (left.kind() != right.kind() || left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            V1 lVal = left.get(i);
            V2 rVal = right.get(i);
            if (lVal == null && rVal == null) continue;
            if (lVal == null || rVal == null) {
                return false;
            }
            if (ValueAccessor.equals(lVal, left.accessor(), rVal, right.accessor())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(ClusteringPrefix<?> prefix, Object o) {
        if (!(o instanceof ClusteringPrefix)) {
            return false;
        }
        return ClusteringPrefix.equals(prefix, (ClusteringPrefix)o);
    }

    public static class Deserializer {
        private final ClusteringComparator comparator;
        private final DataInputPlus in;
        private final SerializationHeader serializationHeader;
        private boolean nextIsRow;
        private long nextHeader;
        private int nextSize;
        private Kind nextKind;
        private int deserializedSize;
        private byte[][] nextValues;
        private final ValueAccessor<byte[]> accessor = ByteArrayAccessor.instance;

        public Deserializer(ClusteringComparator comparator, DataInputPlus in, SerializationHeader header) {
            this.comparator = comparator;
            this.in = in;
            this.serializationHeader = header;
        }

        public void prepare(int flags, int extendedFlags) throws IOException {
            if (UnfilteredSerializer.isStatic(extendedFlags)) {
                throw new IOException("Corrupt flags value for clustering prefix (isStatic flag set): " + flags);
            }
            this.nextIsRow = UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW;
            this.nextKind = this.nextIsRow ? Kind.CLUSTERING : Kind.values()[this.in.readByte()];
            this.nextSize = this.nextIsRow ? this.comparator.size() : this.in.readUnsignedShort();
            this.deserializedSize = 0;
            if (this.nextValues == null || this.nextValues.length != this.nextSize) {
                this.nextValues = new byte[this.nextSize][];
            }
        }

        public <T> int compareNextTo(ClusteringBoundOrBoundary<T> bound) throws IOException {
            if (bound.isTop()) {
                return -1;
            }
            for (int i = 0; i < bound.size(); ++i) {
                if (!this.hasComponent(i)) {
                    return this.nextKind.comparedToClustering;
                }
                int cmp = this.comparator.compareComponent(i, this.nextValues[i], this.accessor, bound.get(i), bound.accessor());
                if (cmp == 0) continue;
                return cmp;
            }
            if (bound.size() == this.nextSize) {
                return Kind.compare(this.nextKind, bound.kind());
            }
            return -bound.kind().comparedToClustering;
        }

        private boolean hasComponent(int i) throws IOException {
            if (i >= this.nextSize) {
                return false;
            }
            while (this.deserializedSize <= i) {
                this.deserializeOne();
            }
            return true;
        }

        private boolean deserializeOne() throws IOException {
            int i;
            if (this.deserializedSize == this.nextSize) {
                return false;
            }
            if (this.deserializedSize % 32 == 0) {
                this.nextHeader = this.in.readUnsignedVInt();
            }
            byte[] byArray = Serializer.isNull(this.nextHeader, i = this.deserializedSize++) ? null : (Serializer.isEmpty(this.nextHeader, i) ? ByteArrayUtil.EMPTY_BYTE_ARRAY : this.serializationHeader.clusteringTypes().get(i).readArray(this.in, DatabaseDescriptor.getMaxValueSize()));
            this.nextValues[i] = byArray;
            return true;
        }

        private void deserializeAll() throws IOException {
            while (this.deserializeOne()) {
            }
        }

        public ClusteringBoundOrBoundary<byte[]> deserializeNextBound() throws IOException {
            assert (!this.nextIsRow);
            this.deserializeAll();
            ClusteringBoundOrBoundary<byte[]> bound = this.accessor.factory().boundOrBoundary(this.nextKind, (V[])this.nextValues);
            this.nextValues = null;
            return bound;
        }

        public Clustering<byte[]> deserializeNextClustering() throws IOException {
            assert (this.nextIsRow);
            this.deserializeAll();
            Clustering<byte[]> clustering = this.accessor.factory().clustering((V[])this.nextValues);
            this.nextValues = null;
            return clustering;
        }

        public Kind skipNext() throws IOException {
            for (int i = this.deserializedSize; i < this.nextSize; ++i) {
                if (i % 32 == 0) {
                    this.nextHeader = this.in.readUnsignedVInt();
                }
                if (Serializer.isNull(this.nextHeader, i) || Serializer.isEmpty(this.nextHeader, i)) continue;
                this.serializationHeader.clusteringTypes().get(i).skipValue(this.in);
            }
            this.deserializedSize = this.nextSize;
            return this.nextKind;
        }
    }

    public static class Serializer {
        public void serialize(ClusteringPrefix<?> clustering, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            assert (clustering.kind() != Kind.STATIC_CLUSTERING);
            if (clustering.kind() == Kind.CLUSTERING) {
                out.writeByte(clustering.kind().ordinal());
                Clustering.serializer.serialize((Clustering)clustering, out, version, types);
            } else {
                ClusteringBoundOrBoundary.serializer.serialize((ClusteringBoundOrBoundary)clustering, out, version, types);
            }
        }

        public void skip(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            Kind kind = Kind.values()[in.readByte()];
            assert (kind != Kind.STATIC_CLUSTERING);
            if (kind == Kind.CLUSTERING) {
                Clustering.serializer.skip(in, version, types);
            } else {
                ClusteringBoundOrBoundary.serializer.skipValues(in, kind, version, types);
            }
        }

        public ClusteringPrefix<byte[]> deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            Kind kind = Kind.values()[in.readByte()];
            assert (kind != Kind.STATIC_CLUSTERING);
            if (kind == Kind.CLUSTERING) {
                return Clustering.serializer.deserialize(in, version, types);
            }
            return ClusteringBoundOrBoundary.serializer.deserializeValues(in, kind, version, types);
        }

        public long serializedSize(ClusteringPrefix<?> clustering, int version, List<AbstractType<?>> types) {
            assert (clustering.kind() != Kind.STATIC_CLUSTERING);
            if (clustering.kind() == Kind.CLUSTERING) {
                return 1L + Clustering.serializer.serializedSize((Clustering)clustering, version, types);
            }
            return ClusteringBoundOrBoundary.serializer.serializedSize((ClusteringBoundOrBoundary)clustering, version, types);
        }

        <V> void serializeValuesWithoutSize(ClusteringPrefix<V> clustering, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            int offset = 0;
            int clusteringSize = clustering.size();
            ValueAccessor<V> accessor = clustering.accessor();
            while (offset < clusteringSize) {
                int limit = Math.min(clusteringSize, offset + 32);
                out.writeUnsignedVInt(Serializer.makeHeader(clustering, offset, limit));
                while (offset < limit) {
                    V v = clustering.get(offset);
                    if (v != null && !accessor.isEmpty(v)) {
                        types.get(offset).writeValue(v, accessor, out);
                    }
                    ++offset;
                }
            }
        }

        <V> long valuesWithoutSizeSerializedSize(ClusteringPrefix<V> clustering, int version, List<AbstractType<?>> types) {
            long result = 0L;
            int offset = 0;
            int clusteringSize = clustering.size();
            while (offset < clusteringSize) {
                int limit = Math.min(clusteringSize, offset + 32);
                result += (long)TypeSizes.sizeofUnsignedVInt(Serializer.makeHeader(clustering, offset, limit));
                offset = limit;
            }
            ValueAccessor<V> accessor = clustering.accessor();
            for (int i = 0; i < clusteringSize; ++i) {
                V v = clustering.get(i);
                if (v == null || accessor.isEmpty(v)) continue;
                result += types.get(i).writtenLength(v, accessor);
            }
            return result;
        }

        byte[][] deserializeValuesWithoutSize(DataInputPlus in, int size, int version, List<AbstractType<?>> types) throws IOException {
            assert (size > 0);
            byte[][] values = new byte[size][];
            int offset = 0;
            while (offset < size) {
                long header = in.readUnsignedVInt();
                int limit = Math.min(size, offset + 32);
                while (offset < limit) {
                    values[offset] = Serializer.isNull(header, offset) ? null : (Serializer.isEmpty(header, offset) ? ByteArrayUtil.EMPTY_BYTE_ARRAY : types.get(offset).readArray(in, DatabaseDescriptor.getMaxValueSize()));
                    ++offset;
                }
            }
            return values;
        }

        void skipValuesWithoutSize(DataInputPlus in, int size, int version, List<AbstractType<?>> types) throws IOException {
            assert (size > 0);
            int offset = 0;
            while (offset < size) {
                long header = in.readUnsignedVInt();
                int limit = Math.min(size, offset + 32);
                while (offset < limit) {
                    if (!Serializer.isNull(header, offset) && !Serializer.isEmpty(header, offset)) {
                        types.get(offset).skipValue(in);
                    }
                    ++offset;
                }
            }
        }

        private static <V> long makeHeader(ClusteringPrefix<V> clustering, int offset, int limit) {
            long header = 0L;
            ValueAccessor<V> accessor = clustering.accessor();
            for (int i = offset; i < limit; ++i) {
                V v = clustering.get(i);
                if (v == null) {
                    header |= 1L << i * 2 + 1;
                    continue;
                }
                if (!accessor.isEmpty(v)) continue;
                header |= 1L << i * 2;
            }
            return header;
        }

        private static boolean isNull(long header, int i) {
            long mask = 1L << i * 2 + 1;
            return (header & mask) != 0L;
        }

        private static boolean isEmpty(long header, int i) {
            long mask = 1L << i * 2;
            return (header & mask) != 0L;
        }
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind EXCL_END_BOUND = new Kind(0, -1);
        public static final /* enum */ Kind INCL_START_BOUND = new Kind(0, -1);
        public static final /* enum */ Kind EXCL_END_INCL_START_BOUNDARY = new Kind(0, -1);
        public static final /* enum */ Kind STATIC_CLUSTERING = new Kind(1, -1);
        public static final /* enum */ Kind CLUSTERING = new Kind(2, 0);
        public static final /* enum */ Kind INCL_END_EXCL_START_BOUNDARY = new Kind(3, 1);
        public static final /* enum */ Kind INCL_END_BOUND = new Kind(3, 1);
        public static final /* enum */ Kind EXCL_START_BOUND = new Kind(3, 1);
        private final int comparison;
        public final int comparedToClustering;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        private Kind(int comparison, int comparedToClustering) {
            this.comparison = comparison;
            this.comparedToClustering = comparedToClustering;
        }

        public static int compare(Kind k1, Kind k2) {
            return Integer.compare(k1.comparison, k2.comparison);
        }

        public Kind invert() {
            switch (this) {
                case EXCL_START_BOUND: {
                    return INCL_END_BOUND;
                }
                case INCL_START_BOUND: {
                    return EXCL_END_BOUND;
                }
                case EXCL_END_BOUND: {
                    return INCL_START_BOUND;
                }
                case INCL_END_BOUND: {
                    return EXCL_START_BOUND;
                }
                case EXCL_END_INCL_START_BOUNDARY: {
                    return INCL_END_EXCL_START_BOUNDARY;
                }
                case INCL_END_EXCL_START_BOUNDARY: {
                    return EXCL_END_INCL_START_BOUNDARY;
                }
            }
            return this;
        }

        public boolean isBound() {
            switch (this) {
                case EXCL_START_BOUND: 
                case INCL_START_BOUND: 
                case EXCL_END_BOUND: 
                case INCL_END_BOUND: {
                    return true;
                }
            }
            return false;
        }

        public boolean isBoundary() {
            switch (this) {
                case EXCL_END_INCL_START_BOUNDARY: 
                case INCL_END_EXCL_START_BOUNDARY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isStart() {
            switch (this) {
                case EXCL_START_BOUND: 
                case INCL_START_BOUND: 
                case EXCL_END_INCL_START_BOUNDARY: 
                case INCL_END_EXCL_START_BOUNDARY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isEnd() {
            switch (this) {
                case EXCL_END_BOUND: 
                case INCL_END_BOUND: 
                case EXCL_END_INCL_START_BOUNDARY: 
                case INCL_END_EXCL_START_BOUNDARY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isOpen(boolean reversed) {
            return this.isBoundary() || (reversed ? this.isEnd() : this.isStart());
        }

        public boolean isClose(boolean reversed) {
            return this.isBoundary() || (reversed ? this.isStart() : this.isEnd());
        }

        public Kind closeBoundOfBoundary(boolean reversed) {
            assert (this.isBoundary());
            return reversed ? (this == INCL_END_EXCL_START_BOUNDARY ? EXCL_START_BOUND : INCL_START_BOUND) : (this == INCL_END_EXCL_START_BOUNDARY ? INCL_END_BOUND : EXCL_END_BOUND);
        }

        public Kind openBoundOfBoundary(boolean reversed) {
            assert (this.isBoundary());
            return reversed ? (this == INCL_END_EXCL_START_BOUNDARY ? INCL_END_BOUND : EXCL_END_BOUND) : (this == INCL_END_EXCL_START_BOUNDARY ? EXCL_START_BOUND : INCL_START_BOUND);
        }

        static {
            $VALUES = new Kind[]{EXCL_END_BOUND, INCL_START_BOUND, EXCL_END_INCL_START_BOUNDARY, STATIC_CLUSTERING, CLUSTERING, INCL_END_EXCL_START_BOUNDARY, INCL_END_BOUND, EXCL_START_BOUND};
        }
    }
}

