/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.CassandraWriteContext;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.KeyspaceWriteHandler;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CassandraKeyspaceWriteHandler
implements KeyspaceWriteHandler {
    private final Keyspace keyspace;

    public CassandraKeyspaceWriteHandler(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    @Override
    public WriteContext beginWrite(Mutation mutation, boolean makeDurable) throws RequestExecutionException {
        OpOrder.Group group = null;
        try {
            group = Keyspace.writeOrder.start();
            CommitLogPosition position = null;
            if (makeDurable) {
                Tracing.trace("Appending to commitlog");
                position = CommitLog.instance.add(mutation);
            }
            return new CassandraWriteContext(group, position);
        }
        catch (Throwable t) {
            if (group != null) {
                group.close();
            }
            throw t;
        }
    }

    private WriteContext createEmptyContext() {
        OpOrder.Group group = null;
        try {
            group = Keyspace.writeOrder.start();
            return new CassandraWriteContext(group, null);
        }
        catch (Throwable t) {
            if (group != null) {
                group.close();
            }
            throw t;
        }
    }

    @Override
    public WriteContext createContextForIndexing() {
        return this.createEmptyContext();
    }

    @Override
    public WriteContext createContextForRead() {
        return this.createEmptyContext();
    }
}

