/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;

public final class TableAttributes
extends PropertyDefinitions {
    public static final String ID = "id";
    private static final Set<String> validKeywords;
    private static final Set<String> obsoleteKeywords;

    public void validate() {
        this.validate(validKeywords, obsoleteKeywords);
        this.build(TableParams.builder()).validate();
    }

    TableParams asNewTableParams() {
        return this.build(TableParams.builder());
    }

    TableParams asAlteredTableParams(TableParams previous) {
        if (this.getId() != null) {
            throw new ConfigurationException("Cannot alter table id.");
        }
        return this.build(previous.unbuild());
    }

    public TableId getId() throws ConfigurationException {
        String id = this.getSimple(ID);
        try {
            return id != null ? TableId.fromString(id) : null;
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Invalid table id", e);
        }
    }

    private TableParams build(TableParams.Builder builder) {
        if (this.hasOption(TableParams.Option.BLOOM_FILTER_FP_CHANCE)) {
            builder.bloomFilterFpChance(this.getDouble(TableParams.Option.BLOOM_FILTER_FP_CHANCE));
        }
        if (this.hasOption(TableParams.Option.CACHING)) {
            builder.caching(CachingParams.fromMap(this.getMap(TableParams.Option.CACHING)));
        }
        if (this.hasOption(TableParams.Option.COMMENT)) {
            builder.comment(this.getString(TableParams.Option.COMMENT));
        }
        if (this.hasOption(TableParams.Option.COMPACTION)) {
            builder.compaction(CompactionParams.fromMap(this.getMap(TableParams.Option.COMPACTION)));
        }
        if (this.hasOption(TableParams.Option.COMPRESSION)) {
            Map<String, String> compressionOpts = this.getMap(TableParams.Option.COMPRESSION);
            if (compressionOpts.containsKey(TableParams.Option.CRC_CHECK_CHANCE.toString().toLowerCase())) {
                Double crcCheckChance = this.getDeprecatedCrcCheckChance(compressionOpts);
                builder.crcCheckChance(crcCheckChance);
            }
            builder.compression(CompressionParams.fromMap(this.getMap(TableParams.Option.COMPRESSION)));
        }
        if (this.hasOption(TableParams.Option.DEFAULT_TIME_TO_LIVE)) {
            builder.defaultTimeToLive(this.getInt(TableParams.Option.DEFAULT_TIME_TO_LIVE));
        }
        if (this.hasOption(TableParams.Option.GC_GRACE_SECONDS)) {
            builder.gcGraceSeconds(this.getInt(TableParams.Option.GC_GRACE_SECONDS));
        }
        if (this.hasOption(TableParams.Option.MAX_INDEX_INTERVAL)) {
            builder.maxIndexInterval(this.getInt(TableParams.Option.MAX_INDEX_INTERVAL));
        }
        if (this.hasOption(TableParams.Option.MEMTABLE_FLUSH_PERIOD_IN_MS)) {
            builder.memtableFlushPeriodInMs(this.getInt(TableParams.Option.MEMTABLE_FLUSH_PERIOD_IN_MS));
        }
        if (this.hasOption(TableParams.Option.MIN_INDEX_INTERVAL)) {
            builder.minIndexInterval(this.getInt(TableParams.Option.MIN_INDEX_INTERVAL));
        }
        if (this.hasOption(TableParams.Option.SPECULATIVE_RETRY)) {
            builder.speculativeRetry(SpeculativeRetryPolicy.fromString(this.getString(TableParams.Option.SPECULATIVE_RETRY)));
        }
        if (this.hasOption(TableParams.Option.ADDITIONAL_WRITE_POLICY)) {
            builder.additionalWritePolicy(SpeculativeRetryPolicy.fromString(this.getString(TableParams.Option.ADDITIONAL_WRITE_POLICY)));
        }
        if (this.hasOption(TableParams.Option.CRC_CHECK_CHANCE)) {
            builder.crcCheckChance(this.getDouble(TableParams.Option.CRC_CHECK_CHANCE));
        }
        if (this.hasOption(TableParams.Option.CDC)) {
            builder.cdc(this.getBoolean(TableParams.Option.CDC.toString(), false));
        }
        if (this.hasOption(TableParams.Option.READ_REPAIR)) {
            builder.readRepair(ReadRepairStrategy.fromString(this.getString(TableParams.Option.READ_REPAIR)));
        }
        return builder.build();
    }

    private Double getDeprecatedCrcCheckChance(Map<String, String> compressionOpts) {
        String value = compressionOpts.get(TableParams.Option.CRC_CHECK_CHANCE.toString().toLowerCase());
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(String.format("Invalid double value %s for crc_check_chance.'", value));
        }
    }

    private double getDouble(TableParams.Option option) {
        String value = this.getString(option);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(String.format("Invalid double value %s for '%s'", new Object[]{value, option}));
        }
    }

    private int getInt(TableParams.Option option) {
        String value = this.getString(option);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(String.format("Invalid integer value %s for '%s'", new Object[]{value, option}));
        }
    }

    private String getString(TableParams.Option option) {
        String value = this.getSimple(option.toString());
        if (value == null) {
            throw new IllegalStateException(String.format("Option '%s' is absent", new Object[]{option}));
        }
        return value;
    }

    private Map<String, String> getMap(TableParams.Option option) {
        Map<String, String> value = this.getMap(option.toString());
        if (value == null) {
            throw new IllegalStateException(String.format("Option '%s' is absent", new Object[]{option}));
        }
        return value;
    }

    public boolean hasOption(TableParams.Option option) {
        return this.hasProperty(option.toString());
    }

    static {
        ImmutableSet.Builder validBuilder = ImmutableSet.builder();
        for (TableParams.Option option : TableParams.Option.values()) {
            validBuilder.add((Object)option.toString());
        }
        validBuilder.add((Object)ID);
        validKeywords = validBuilder.build();
        obsoleteKeywords = ImmutableSet.of();
    }
}

