/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public class IndexTarget {
    public static final String TARGET_OPTION_NAME = "target";
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public final ColumnIdentifier column;
    public final Type type;

    public IndexTarget(ColumnIdentifier column, Type type) {
        this.column = column;
        this.type = type;
    }

    public String asCqlString() {
        return this.type == Type.SIMPLE ? this.column.toCQLString() : String.format("%s(%s)", this.type.toString(), this.column.toCQLString());
    }

    public String toString() {
        return this.asCqlString();
    }

    public static enum Type {
        VALUES,
        KEYS,
        KEYS_AND_VALUES,
        FULL,
        SIMPLE;


        public String toString() {
            switch (this) {
                case KEYS: {
                    return "keys";
                }
                case KEYS_AND_VALUES: {
                    return "entries";
                }
                case FULL: {
                    return "full";
                }
                case VALUES: {
                    return "values";
                }
                case SIMPLE: {
                    return "";
                }
            }
            return "";
        }

        public static Type fromString(String s) {
            if ("".equals(s)) {
                return SIMPLE;
            }
            if ("values".equals(s)) {
                return VALUES;
            }
            if ("keys".equals(s)) {
                return KEYS;
            }
            if ("entries".equals(s)) {
                return KEYS_AND_VALUES;
            }
            if ("full".equals(s)) {
                return FULL;
            }
            throw new AssertionError((Object)("Unrecognized index target type " + s));
        }
    }

    public static class Raw {
        private final ColumnIdentifier column;
        private final Type type;

        private Raw(ColumnIdentifier column, Type type) {
            this.column = column;
            this.type = type;
        }

        public static Raw simpleIndexOn(ColumnIdentifier c) {
            return new Raw(c, Type.SIMPLE);
        }

        public static Raw valuesOf(ColumnIdentifier c) {
            return new Raw(c, Type.VALUES);
        }

        public static Raw keysOf(ColumnIdentifier c) {
            return new Raw(c, Type.KEYS);
        }

        public static Raw keysAndValuesOf(ColumnIdentifier c) {
            return new Raw(c, Type.KEYS_AND_VALUES);
        }

        public static Raw fullCollection(ColumnIdentifier c) {
            return new Raw(c, Type.FULL);
        }

        public IndexTarget prepare(TableMetadata table) {
            ColumnMetadata columnDef = table.getExistingColumn(this.column);
            Type actualType = this.type == Type.SIMPLE && columnDef.type.isCollection() ? Type.VALUES : this.type;
            return new IndexTarget(columnDef.name, actualType);
        }
    }
}

