/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.List;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.ColumnMetadata;

abstract class CollectionFactory
extends Selector.Factory {
    private final AbstractType<?> type;
    private final SelectorFactories factories;

    public CollectionFactory(AbstractType<?> type, SelectorFactories factories) {
        this.type = type;
        this.factories = factories;
    }

    @Override
    protected final AbstractType<?> getReturnType() {
        return this.type;
    }

    @Override
    public final void addFunctionsTo(List<Function> functions) {
        this.factories.addFunctionsTo(functions);
    }

    @Override
    public final boolean isAggregateSelectorFactory() {
        return this.factories.doesAggregation();
    }

    @Override
    public final boolean isWritetimeSelectorFactory() {
        return this.factories.containsWritetimeSelectorFactory();
    }

    @Override
    public final boolean isTTLSelectorFactory() {
        return this.factories.containsTTLSelectorFactory();
    }

    @Override
    boolean areAllFetchedColumnsKnown() {
        return this.factories.areAllFetchedColumnsKnown();
    }

    @Override
    void addFetchedColumns(ColumnFilter.Builder builder) {
        this.factories.addFetchedColumns(builder);
    }

    @Override
    protected final void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
        SelectionColumnMapping tmpMapping = SelectionColumnMapping.newMapping();
        for (Selector.Factory factory : this.factories) {
            factory.addColumnMapping(tmpMapping, resultsColumn);
        }
        if (tmpMapping.getMappings().get((Object)resultsColumn).isEmpty()) {
            mapping.addMapping(resultsColumn, (ColumnMetadata)null);
        } else {
            mapping.addMapping(resultsColumn, tmpMapping.getMappings().values());
        }
    }
}

