/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.cloud.bigtable.stats.BigtableStackdriverStatsExporter;
import com.google.cloud.bigtable.stats.BuiltinViews;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public final class BigtableDataSettings {
    private static final Logger LOGGER = Logger.getLogger(BigtableDataSettings.class.getName());
    private static final String BIGTABLE_EMULATOR_HOST_ENV_VAR = "BIGTABLE_EMULATOR_HOST";
    private static final AtomicBoolean BUILTIN_METRICS_REGISTERED = new AtomicBoolean(false);
    private final EnhancedBigtableStubSettings stubSettings;

    private BigtableDataSettings(Builder builder) {
        this.stubSettings = builder.stubSettings().build();
    }

    public static Builder newBuilder() {
        String hostAndPort = System.getenv(BIGTABLE_EMULATOR_HOST_ENV_VAR);
        if (!Strings.isNullOrEmpty((String)hostAndPort)) {
            try {
                int lastIndexOfCol = hostAndPort.lastIndexOf(":");
                int port = Integer.parseInt(hostAndPort.substring(lastIndexOfCol + 1));
                return BigtableDataSettings.newBuilderForEmulator(hostAndPort.substring(0, lastIndexOfCol), port);
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                throw new RuntimeException("Invalid host/port in BIGTABLE_EMULATOR_HOST environment variable: " + hostAndPort);
            }
        }
        return new Builder();
    }

    public static Builder newBuilderForEmulator(int port) {
        return BigtableDataSettings.newBuilderForEmulator("localhost", port);
    }

    public static Builder newBuilderForEmulator(String hostname, int port) {
        Builder builder = new Builder();
        ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)builder.stubSettings().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setEndpoint(hostname + ":" + port)).setRefreshingChannel(false).setTransportChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(0x10000000)).setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)1)).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setKeepAliveTime(Duration.ofSeconds((long)61L)).setKeepAliveTimeout(Duration.ofSeconds((long)10L)).build());
        LOGGER.info("Connecting to the Bigtable emulator at " + hostname + ":" + port);
        return builder;
    }

    @BetaApi(value="OpenCensus stats integration is currently unstable and may change in the future")
    public static void enableOpenCensusStats() {
        RpcViews.registerBigtableClientViews();
    }

    @BetaApi(value="OpenCensus stats integration is currently unstable and may change in the future")
    public static void enableGfeOpenCensusStats() {
        RpcViews.registerBigtableClientGfeViews();
    }

    @BetaApi(value="Built in metric is not currently stable and may change in the future")
    public static void enableBuiltinMetrics() throws IOException {
        if (BUILTIN_METRICS_REGISTERED.compareAndSet(false, true)) {
            BuiltinViews.registerBigtableBuiltinViews();
            BigtableStackdriverStatsExporter.register((Credentials)GoogleCredentials.getApplicationDefault());
        }
    }

    @BetaApi(value="Built in metric is not currently stable and may change in the future")
    public static void enableBuiltinMetrics(Credentials credentials) throws IOException {
        if (BUILTIN_METRICS_REGISTERED.compareAndSet(false, true)) {
            BuiltinViews.registerBigtableBuiltinViews();
            BigtableStackdriverStatsExporter.register((Credentials)credentials);
        }
    }

    public String getProjectId() {
        return this.stubSettings.getProjectId();
    }

    public String getInstanceId() {
        return this.stubSettings.getInstanceId();
    }

    public String getAppProfileId() {
        return this.stubSettings.getAppProfileId();
    }

    @Deprecated
    public boolean isRefreshingChannel() {
        return this.stubSettings.isRefreshingChannel();
    }

    @Deprecated
    public List<String> getPrimingTableIds() {
        return this.stubSettings.getPrimedTableIds();
    }

    @BetaApi(value="Latency based throttling is not currently stable and may change in the future")
    public boolean isLatencyBasedThrottlingForBatchMutationsEnabled() {
        return this.stubSettings.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled();
    }

    @BetaApi(value="Latency based throttling is not currently stable and may change in the future")
    @Nullable
    public Long getBatchMutationsTargetRpcLatencyMs() {
        return this.stubSettings.bulkMutateRowsSettings().getTargetRpcLatencyMs();
    }

    public EnhancedBigtableStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public UnaryCallSettings<Query, Row> readRowSettings() {
        return this.stubSettings.readRowSettings();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stubSettings", (Object)this.stubSettings).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private final EnhancedBigtableStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = EnhancedBigtableStubSettings.newBuilder();
        }

        private Builder(BigtableDataSettings settings) {
            this.stubSettings = settings.getStubSettings().toBuilder();
        }

        public Builder setProjectId(@Nonnull String projectId) {
            this.stubSettings.setProjectId(projectId);
            return this;
        }

        public String getProjectId() {
            return this.stubSettings.getProjectId();
        }

        public Builder setInstanceId(@Nonnull String instanceId) {
            this.stubSettings.setInstanceId(instanceId);
            return this;
        }

        public String getInstanceId() {
            return this.stubSettings.getInstanceId();
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            this.stubSettings.setAppProfileId(appProfileId);
            return this;
        }

        public Builder setDefaultAppProfileId() {
            this.stubSettings.setDefaultAppProfileId();
            return this;
        }

        public String getAppProfileId() {
            return this.stubSettings.getAppProfileId();
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        @Deprecated
        public Builder setRefreshingChannel(boolean isRefreshingChannel) {
            this.stubSettings.setRefreshingChannel(isRefreshingChannel);
            return this;
        }

        @Deprecated
        public boolean isRefreshingChannel() {
            return this.stubSettings.isRefreshingChannel();
        }

        @Deprecated
        public Builder setPrimingTableIds(String ... tableIds) {
            this.stubSettings.setPrimedTableIds(tableIds);
            return this;
        }

        @Deprecated
        public List<String> getPrimingTableIds() {
            return this.stubSettings.getPrimedTableIds();
        }

        @BetaApi(value="Latency based throttling is not currently stable and may change in the future")
        public Builder enableBatchMutationLatencyBasedThrottling(long targetRpcLatencyMs) {
            this.stubSettings.bulkMutateRowsSettings().enableLatencyBasedThrottling(targetRpcLatencyMs);
            return this;
        }

        @BetaApi(value="Latency based throttling is not currently stable and may change in the future")
        public Builder disableBatchMutationLatencyBasedThrottling() {
            this.stubSettings.bulkMutateRowsSettings().disableLatencyBasedThrottling();
            return this;
        }

        @BetaApi(value="Latency based throttling is not currently stable and may change in the future")
        public boolean isLatencyBasedThrottlingForBatchMutationEnabled() {
            return this.stubSettings.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled();
        }

        @BetaApi(value="Latency based throttling is not currently stable and may change in the future")
        @Nullable
        public Long getTargetRpcLatencyMsForBatchMutation() {
            return this.stubSettings.bulkMutateRowsSettings().getTargetRpcLatencyMs();
        }

        public EnhancedBigtableStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableDataSettings build() {
            return new BigtableDataSettings(this);
        }
    }
}

