/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.search;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.search.ISearchablesLocation;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.search.ProjectsSearchablesLocation;
import org.apache.hop.ui.core.gui.HopNamespace;

@ExtensionPoint(id="AddProjectsSearchablesLocationExtensionPoint", description="Adds a search location to the search perspective", extensionPointId="HopGuiGetSearchablesLocations")
public class AddProjectsSearchablesLocationExtensionPoint
implements IExtensionPoint<List<ISearchablesLocation>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, List<ISearchablesLocation> searchablesLocations) throws HopException {
        String projectName = HopNamespace.getNamespace();
        if (projectName == null) {
            return;
        }
        ProjectConfig projectConfig = ProjectsConfigSingleton.getConfig().findProjectConfig(projectName);
        if (projectConfig == null) {
            return;
        }
        try {
            ProjectsSearchablesLocation projectsSearchablesLocation = new ProjectsSearchablesLocation(projectConfig);
            searchablesLocations.add(projectsSearchablesLocation);
        }
        catch (Exception e) {
            log.logError("Error getting project searchables", (Throwable)e);
        }
    }
}

