/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.script;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.script.ScriptMeta;
import org.apache.hop.pipeline.transforms.script.ScriptUtils;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ScriptDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ScriptDialog.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private CCombo wEngines;
    private ModifyListener lsMod;
    private TableView wFields;
    private Label wlPosition;
    private Tree wTree;
    private TreeItem wTreeScriptsItem;
    private Image imageActiveScript;
    private Image imageInactiveScript;
    private Image imageActiveStartScript;
    private Image imageActiveEndScript;
    private Image imageArrowOrange;
    private Image imageArrowGreen;
    private CTabFolder folder;
    private Menu cMenu;
    private Menu tMenu;
    private TreeItem[] lastItem;
    private TreeEditor editor;
    private static final int DELETE_ITEM = 0;
    private static final int ADD_ITEM = 1;
    private static final int RENAME_ITEM = 2;
    private static final int SET_ACTIVE_ITEM = 3;
    private static final int ADD_COPY = 2;
    private static final int ADD_BLANK = 1;
    private static final int ADD_DEFAULT = 0;
    private String strActiveScript;
    private String strActiveStartScript;
    private String strActiveEndScript;
    private ScriptMeta input;
    private TreeItem itemInput;
    private TreeItem itemOutput;
    private IRowMeta rowPrevStepFields;

    public ScriptDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (ScriptMeta)((Object)in);
        try {
            this.imageArrowGreen = GuiResource.getInstance().getImage("arrowGreen.svg", ((Object)((Object)this)).getClass().getClassLoader(), 16, 16);
            this.imageArrowOrange = GuiResource.getInstance().getImage("arrowOrange.svg", ((Object)((Object)this)).getClass().getClassLoader(), 16, 16);
            this.imageActiveScript = GuiResource.getInstance().getImage("ui/images/script-active.svg");
            this.imageInactiveScript = GuiResource.getInstance().getImage("ui/images/script-inactive.svg");
            this.imageActiveStartScript = GuiResource.getInstance().getImage("ui/images/script-start.svg");
            this.imageActiveEndScript = GuiResource.getInstance().getImage("ui/images/script-end.svg");
        }
        catch (Exception e) {
            this.imageArrowOrange = GuiResource.getInstance().getImageEmpty();
            this.imageArrowGreen = GuiResource.getInstance().getImageEmpty();
            this.imageActiveScript = GuiResource.getInstance().getImageEmpty();
            this.imageInactiveScript = GuiResource.getInstance().getImageEmpty();
            this.imageActiveStartScript = GuiResource.getInstance().getImageEmpty();
            this.imageActiveEndScript = GuiResource.getInstance().getImageEmpty();
        }
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, this.input);
        this.lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        this.shell.setLayout(this.props.createFormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlEngines = new Label((Composite)this.shell, 131072);
        wlEngines.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.ScriptEngine.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEngines);
        FormData fdlEngines = new FormData();
        fdlEngines.left = new FormAttachment(0, 0);
        fdlEngines.right = new FormAttachment(middle, -margin);
        fdlEngines.top = new FormAttachment((Control)this.wTransformName, margin);
        wlEngines.setLayoutData((Object)fdlEngines);
        this.wEngines = new CCombo((Composite)this.shell, 18440);
        List<String> scriptEngineNames = ScriptUtils.getScriptLanguageNames();
        if (scriptEngineNames != null) {
            Collections.sort(scriptEngineNames);
            for (String engineName : scriptEngineNames) {
                this.wEngines.add(engineName);
            }
        }
        this.wEngines.select(0);
        PropsUi.setLook((Widget)this.wEngines);
        this.wEngines.addModifyListener(this.lsMod);
        FormData fdEngines = new FormData();
        fdEngines.left = new FormAttachment(middle, 0);
        fdEngines.top = new FormAttachment((Control)this.wTransformName, margin);
        fdEngines.right = new FormAttachment(100, 0);
        this.wEngines.setLayoutData((Object)fdEngines);
        SashForm wSash = new SashForm((Composite)this.shell, 512);
        wSash.setLayout((Layout)new FormLayout());
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.top = new FormAttachment((Control)this.wEngines, 0);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.bottom = new FormAttachment(100, 0);
        wSash.setLayoutData((Object)fdSashForm);
        Composite wTop = new Composite((Composite)wSash, 0);
        PropsUi.setLook((Widget)wTop);
        wTop.setLayout(this.props.createFormLayout());
        Label wlScriptFunctions = new Label(wTop, 0);
        wlScriptFunctions.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.ScriptFunctions.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScriptFunctions);
        FormData fdlScriptFunctions = new FormData();
        fdlScriptFunctions.left = new FormAttachment(0, 0);
        fdlScriptFunctions.top = new FormAttachment(0, 0);
        wlScriptFunctions.setLayoutData((Object)fdlScriptFunctions);
        this.wTree = new Tree(wTop, 2816);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdlTree = new FormData();
        fdlTree.left = new FormAttachment(0, 0);
        fdlTree.top = new FormAttachment((Control)wlScriptFunctions, margin);
        fdlTree.right = new FormAttachment(20, 0);
        fdlTree.bottom = new FormAttachment(100, -margin);
        this.wTree.setLayoutData((Object)fdlTree);
        Label wlScript = new Label(wTop, 0);
        wlScript.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Script.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScript);
        FormData fdlScript = new FormData();
        fdlScript.left = new FormAttachment((Control)this.wTree, margin);
        fdlScript.top = new FormAttachment(0, 0);
        wlScript.setLayoutData((Object)fdlScript);
        this.folder = new CTabFolder(wTop, 2064);
        this.folder.setSimple(false);
        this.folder.setUnselectedImageVisible(true);
        this.folder.setUnselectedCloseVisible(true);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment((Control)this.wTree, margin);
        fdScript.top = new FormAttachment((Control)wlScript, margin);
        fdScript.right = new FormAttachment(100, -5);
        fdScript.bottom = new FormAttachment(100, -50);
        this.folder.setLayoutData((Object)fdScript);
        this.wlPosition = new Label(wTop, 0);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Position.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment((Control)this.wTree, margin);
        fdlPosition.right = new FormAttachment(30, 0);
        fdlPosition.top = new FormAttachment((Control)this.folder, margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        Text wlHelpLabel = new Text(wTop, 16896);
        wlHelpLabel.setEditable(false);
        wlHelpLabel.setText("Hallo");
        PropsUi.setLook((Widget)wlHelpLabel);
        FormData fdHelpLabel = new FormData();
        fdHelpLabel.left = new FormAttachment((Control)this.wlPosition, margin);
        fdHelpLabel.top = new FormAttachment((Control)this.folder, margin);
        fdHelpLabel.right = new FormAttachment(100, -5);
        fdHelpLabel.bottom = new FormAttachment(100, 0);
        wlHelpLabel.setLayoutData((Object)fdHelpLabel);
        wlHelpLabel.setVisible(false);
        FormData fdTop = new FormData();
        fdTop.left = new FormAttachment(0, 0);
        fdTop.top = new FormAttachment(0, 0);
        fdTop.right = new FormAttachment(100, 0);
        fdTop.bottom = new FormAttachment(100, 0);
        wTop.setLayoutData((Object)fdTop);
        Composite wBottom = new Composite((Composite)wSash, 0);
        PropsUi.setLook((Widget)wBottom);
        wBottom.setLayout(this.props.createFormLayout());
        Label wSeparator = new Label(wBottom, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(0, 0);
        fdSeparator.right = new FormAttachment(100, 0);
        fdSeparator.top = new FormAttachment(0, -margin + 2);
        wSeparator.setLayoutData((Object)fdSeparator);
        Label wlFields = new Label(wBottom, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)wSeparator, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int nrFields = this.input.getFields().size();
        ColumnInfo scriptResultColumn = new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.ReturnValue", (String[])new String[0]), 2, YES_NO_COMBO);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.Filename", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.RenameTo", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ScriptDialog.ColumnInfo.Replace", (String[])new String[0]), 2, YES_NO_COMBO), scriptResultColumn};
        this.wFields = new TableView(this.variables, wBottom, 67586, colinf, nrFields, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdBottom = new FormData();
        fdBottom.left = new FormAttachment(0, 0);
        fdBottom.top = new FormAttachment(0, 0);
        fdBottom.right = new FormAttachment(100, 0);
        fdBottom.bottom = new FormAttachment(100, 0);
        wBottom.setLayoutData((Object)fdBottom);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment((Control)this.wEngines, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wSash.setLayoutData((Object)fdSash);
        wSash.setWeights(new int[]{75, 25});
        this.folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem cItem = (CTabItem)event.item;
                event.doit = false;
                if (cItem != null && ScriptDialog.this.folder.getItemCount() > 1) {
                    MessageBox messageBox = new MessageBox(ScriptDialog.this.shell, 196);
                    messageBox.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.DeleteItem.Label", (String[])new String[0]));
                    messageBox.setMessage(BaseMessages.getString(PKG, (String)"ScriptDialog.ConfirmDeleteItem.Label", (String[])new String[]{cItem.getText()}));
                    if (messageBox.open() == 64) {
                        ScriptDialog.this.modifyScriptTree(cItem, 0);
                        event.doit = true;
                    }
                }
            }
        });
        this.cMenu = new Menu((Decorations)this.shell, 8);
        this.buildingFolderMenu();
        this.tMenu = new Menu((Decorations)this.shell, 8);
        this.buildingTreeMenu();
        this.wTreeScriptsItem = new TreeItem(this.wTree, 0);
        this.wTreeScriptsItem.setImage(GuiResource.getInstance().getImageBol());
        this.wTreeScriptsItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.TransformScript.Label", (String[])new String[0]));
        this.setSize();
        this.getData();
        this.buildSpecialFunctionsTree();
        this.itemInput = new TreeItem(this.wTree, 0);
        this.itemInput.setImage(GuiResource.getInstance().getImageInput());
        this.itemInput.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.InputFields.Label", (String[])new String[0]));
        this.itemOutput = new TreeItem(this.wTree, 0);
        this.itemOutput.setImage(GuiResource.getInstance().getImageOutput());
        this.itemOutput.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.OutputFields.Label", (String[])new String[0]));
        TreeItem itemWaitFieldsIn = new TreeItem(this.itemInput, 0);
        itemWaitFieldsIn.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsIn.setForeground(GuiResource.getInstance().getColorDirectory());
        this.itemInput.setExpanded(true);
        TreeItem itemWaitFieldsOut = new TreeItem(this.itemOutput, 0);
        itemWaitFieldsOut.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.GettingFields.Label", (String[])new String[0]));
        itemWaitFieldsOut.setForeground(GuiResource.getInstance().getColorDirectory());
        this.itemOutput.setExpanded(true);
        Runnable runnable = () -> {
            TransformMeta stepMeta = this.pipelineMeta.findTransform(this.transformName);
            if (stepMeta != null) {
                try {
                    this.rowPrevStepFields = this.pipelineMeta.getPrevTransformFields(this.variables, stepMeta);
                    if (this.rowPrevStepFields != null) {
                        this.setInputOutputFields();
                    } else {
                        this.itemInput.removeAll();
                        this.itemOutput.removeAll();
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.addRenameToTreeScriptItems();
        this.input.setChanged(this.changed);
        DragSource ds = new DragSource((Control)this.wTree, 2);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                TreeItem item = ScriptDialog.this.wTree.getSelection()[0];
                if (item != null && item.getParentItem() != null) {
                    if (item.getParentItem().equals(ScriptDialog.this.wTreeScriptsItem)) {
                        event.doit = false;
                    } else if (!item.getData().equals("Function")) {
                        String strInsert = (String)item.getData();
                        event.doit = strInsert.equals("jsFunction");
                    } else {
                        event.doit = false;
                    }
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = ScriptDialog.this.wTree.getSelection()[0].getText();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    private void setActiveCTab(String strName) {
        if (StringUtils.isEmpty((String)strName)) {
            this.folder.setSelection(0);
        } else {
            this.folder.setSelection(this.getCTabPosition(strName));
        }
    }

    private void addCTab(String cScriptName, String strScript, int iType) {
        CTabItem item = new CTabItem(this.folder, 64);
        if (iType == 0) {
            item.setText(Const.NVL((String)cScriptName, (String)""));
        } else {
            item.setText(this.getNextName(cScriptName));
        }
        StyledTextComp wScript = new StyledTextComp(this.variables, (Composite)item.getParent(), 17154, false);
        if (strScript != null && strScript.length() > 0) {
            wScript.setText(strScript);
        } else {
            wScript.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.ScriptHere.Label", (String[])new String[0]) + Const.CR + Const.CR);
        }
        item.setImage(this.imageInactiveScript);
        PropsUi.setLook((Widget)wScript, (int)1);
        wScript.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ScriptDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                ScriptDialog.this.setPosition();
            }
        });
        wScript.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ScriptDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                ScriptDialog.this.setPosition();
            }
        });
        wScript.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ScriptDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                ScriptDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                ScriptDialog.this.setPosition();
            }
        });
        wScript.addModifyListener(this.lsMod);
        item.setControl((Control)wScript);
        this.modifyScriptTree(item, 1);
    }

    private void modifyScriptTree(CTabItem ctabitem, int iModType) {
        switch (iModType) {
            case 0: {
                TreeItem dItem = this.getTreeItemByName(ctabitem.getText());
                if (dItem == null) break;
                dItem.dispose();
                this.input.setChanged();
                break;
            }
            case 1: {
                TreeItem item = new TreeItem(this.wTreeScriptsItem, 0);
                item.setImage(this.imageActiveScript);
                item.setText(ctabitem.getText());
                this.input.setChanged();
                break;
            }
            case 2: {
                this.input.setChanged();
                break;
            }
            case 3: {
                this.input.setChanged();
                break;
            }
        }
    }

    private TreeItem getTreeItemByName(String strTabName) {
        TreeItem[] tItems;
        for (TreeItem tItem : tItems = this.wTreeScriptsItem.getItems()) {
            if (!tItem.getText().equals(strTabName)) continue;
            return tItem;
        }
        return null;
    }

    private int getCTabPosition(String strTabName) {
        CTabItem[] cItems = this.folder.getItems();
        for (int i = 0; i < cItems.length; ++i) {
            if (!cItems[i].getText().equals(strTabName)) continue;
            return i;
        }
        return -1;
    }

    private CTabItem getCTabItemByName(String strTabName) {
        CTabItem[] cItems;
        for (CTabItem cItem : cItems = this.folder.getItems()) {
            if (!cItem.getText().equals(strTabName)) continue;
            return cItem;
        }
        return null;
    }

    private void modifyCTabItem(TreeItem tItem, int iModType, String strOption) {
        switch (iModType) {
            case 0: {
                CTabItem dItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (dItem == null) break;
                dItem.dispose();
                this.input.setChanged();
                break;
            }
            case 2: {
                CTabItem rItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (rItem == null) break;
                rItem.setText(strOption);
                this.input.setChanged();
                if (rItem.getImage().equals((Object)this.imageActiveScript)) {
                    this.strActiveScript = strOption;
                    break;
                }
                if (rItem.getImage().equals((Object)this.imageActiveStartScript)) {
                    this.strActiveStartScript = strOption;
                    break;
                }
                if (!rItem.getImage().equals((Object)this.imageActiveEndScript)) break;
                this.strActiveEndScript = strOption;
                break;
            }
            case 3: {
                CTabItem aItem = this.folder.getItem(this.getCTabPosition(tItem.getText()));
                if (aItem == null) break;
                this.input.setChanged();
                this.strActiveScript = tItem.getText();
                for (int i = 0; i < this.folder.getItemCount(); ++i) {
                    if (this.folder.getItem(i).equals(aItem)) {
                        aItem.setImage(this.imageActiveScript);
                        continue;
                    }
                    this.folder.getItem(i).setImage(this.imageInactiveScript);
                }
                break;
            }
        }
    }

    private StyledTextComp getStyledTextComp() {
        CTabItem item = this.folder.getSelection();
        if (item.getControl().isDisposed()) {
            return null;
        }
        return (StyledTextComp)item.getControl();
    }

    private StyledTextComp getStyledTextComp(CTabItem item) {
        return (StyledTextComp)item.getControl();
    }

    private String getNextName(String strActualName) {
        Object strRC = "";
        if (strActualName.length() == 0) {
            strActualName = "Item";
        }
        int i = 0;
        strRC = strActualName + "_" + i;
        while (this.getCTabItemByName((String)strRC) != null) {
            strRC = strActualName + "_" + ++i;
        }
        return strRC;
    }

    public void setPosition() {
        StyledTextComp wScript = this.getStyledTextComp();
        if (wScript == null) {
            return;
        }
        int lineNumber = wScript.getLineNumber();
        int columnNumber = wScript.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Position.Label2", (String[])new String[0]) + lineNumber + ", " + columnNumber);
    }

    public void getData() {
        String engineName = this.input.getLanguageName();
        if (StringUtils.isEmpty((String)engineName) || !ScriptUtils.getScriptLanguageNames().contains(engineName)) {
            this.wEngines.select(0);
        } else {
            this.wEngines.setText(engineName);
        }
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            ScriptMeta.SField field = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            item.setText(2, Const.NVL((String)field.getRename(), (String)""));
            item.setText(3, Const.NVL((String)field.getType(), (String)""));
            if (field.getLength() >= 0) {
                item.setText(4, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                item.setText(5, "" + field.getPrecision());
            }
            item.setText(6, field.isReplace() ? YES_NO_COMBO[1] : YES_NO_COMBO[0]);
            item.setText(7, field.isScriptResult() ? YES_NO_COMBO[1] : YES_NO_COMBO[0]);
        }
        List<ScriptMeta.SScript> jsScripts = this.input.getScripts();
        if (!jsScripts.isEmpty()) {
            for (int i = 0; i < jsScripts.size(); ++i) {
                ScriptMeta.SScript script = jsScripts.get(i);
                if (script.isTransformScript()) {
                    this.strActiveScript = script.getScriptName();
                } else if (script.isStartScript()) {
                    this.strActiveStartScript = script.getScriptName();
                } else if (script.isEndScript()) {
                    this.strActiveEndScript = script.getScriptName();
                }
                this.addCTab(script.getScriptName(), script.getScript(), 0);
            }
        } else {
            this.addCTab("script1", "", 0);
        }
        this.setActiveCTab(this.strActiveScript);
        this.refresh();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void refresh() {
        for (int i = 0; i < this.folder.getItemCount(); ++i) {
            CTabItem item = this.folder.getItem(i);
            if (item.getText().equals(this.strActiveScript)) {
                item.setImage(this.imageActiveScript);
                continue;
            }
            if (item.getText().equals(this.strActiveStartScript)) {
                item.setImage(this.imageActiveStartScript);
                continue;
            }
            if (item.getText().equals(this.strActiveEndScript)) {
                item.setImage(this.imageActiveEndScript);
                continue;
            }
            item.setImage(this.imageInactiveScript);
        }
    }

    private boolean cancel() {
        if (this.input.hasChanged()) {
            MessageBox box = new MessageBox(this.shell, 65728);
            box.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.WarningDialogChanged.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"ScriptDialog.WarningDialogChanged.Message", (String[])new String[]{Const.CR}));
            int answer = box.open();
            if (answer == 128) {
                return false;
            }
        }
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
        return true;
    }

    private void getInfo(ScriptMeta meta) {
        meta.setLanguageName(this.wEngines.getText());
        meta.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            ScriptMeta.SField field = new ScriptMeta.SField();
            field.setName(item.getText(1));
            field.setRename(item.getText(2));
            if (field.getRename() == null || field.getRename().length() == 0 || field.getRename().equalsIgnoreCase(field.getName())) {
                field.setRename(field.getName());
            }
            field.setType(item.getText(3));
            String slen = item.getText(4);
            String sprc = item.getText(5);
            field.setLength(Const.toInt((String)slen, (int)-1));
            field.setPrecision(Const.toInt((String)sprc, (int)-1));
            field.setReplace(YES_NO_COMBO[1].equalsIgnoreCase(item.getText(6)));
            field.setScriptResult(YES_NO_COMBO[1].equalsIgnoreCase(item.getText(7)));
            meta.getFields().add(field);
        }
        meta.getScripts().clear();
        CTabItem[] cTabs = this.folder.getItems();
        if (cTabs.length > 0) {
            for (int i = 0; i < cTabs.length; ++i) {
                ScriptMeta.SScript jsScript = new ScriptMeta.SScript(ScriptMeta.ScriptType.NORMAL_SCRIPT, cTabs[i].getText(), this.getStyledTextComp(cTabs[i]).getText());
                if (cTabs[i].getImage().equals((Object)this.imageActiveScript)) {
                    jsScript.setScriptType(ScriptMeta.ScriptType.TRANSFORM_SCRIPT);
                } else if (cTabs[i].getImage().equals((Object)this.imageActiveStartScript)) {
                    jsScript.setScriptType(ScriptMeta.ScriptType.START_SCRIPT);
                } else if (cTabs[i].getImage().equals((Object)this.imageActiveEndScript)) {
                    jsScript.setScriptType(ScriptMeta.ScriptType.END_SCRIPT);
                }
                meta.getScripts().add(jsScript);
            }
        }
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        boolean bInputOK = false;
        if (this.getCTabItemByName(this.strActiveScript) == null) {
            MessageBox mb = new MessageBox(this.shell, 289);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ScriptDialog.NoActiveScriptSet", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.ERROR.Label", (String[])new String[0]));
            switch (mb.open()) {
                case 32: {
                    this.strActiveScript = this.folder.getItem(0).getText();
                    this.refresh();
                    bInputOK = true;
                    break;
                }
            }
        } else {
            bInputOK = true;
        }
        if (bInputOK) {
            this.getInfo(this.input);
            this.dispose();
        }
    }

    private void buildSpecialFunctionsTree() {
        TreeItem item = new TreeItem(this.wTree, 0);
        item.setImage(GuiResource.getInstance().getImageBol());
        item.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.TransformConstant.Label", (String[])new String[0]));
        TreeItem itemT = new TreeItem(item, 0);
        itemT.setImage(this.imageArrowGreen);
        itemT.setText("SKIP_TRANSFORMATION");
        itemT.setData((Object)"SKIP_TRANSFORMATION");
        itemT = new TreeItem(item, 0);
        itemT.setImage(this.imageArrowGreen);
        itemT.setText("ERROR_TRANSFORMATION");
        itemT.setData((Object)"ERROR_TRANSFORMATION");
        itemT = new TreeItem(item, 0);
        itemT.setImage(this.imageArrowGreen);
        itemT.setText("CONTINUE_TRANSFORMATION");
        itemT.setData((Object)"CONTINUE_TRANSFORMATION");
    }

    public boolean checkTreeItemExist(TreeItem itemToCheck, String strItemName) {
        boolean bRC = false;
        if (itemToCheck.getItemCount() > 0) {
            TreeItem[] items = itemToCheck.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].getText().equals(strItemName)) continue;
                return true;
            }
        }
        return bRC;
    }

    private void setInputOutputFields() {
        this.shell.getDisplay().syncExec(() -> {
            this.itemInput.removeAll();
            this.itemOutput.removeAll();
            String strItemInToAdd = "";
            String strItemToAddOut = "";
            if (this.rowPrevStepFields != null) {
                int i;
                for (i = 0; i < this.rowPrevStepFields.size(); ++i) {
                    IValueMeta v = this.rowPrevStepFields.getValueMeta(i);
                    strItemToAddOut = v.getName();
                    strItemInToAdd = v.getName();
                    TreeItem itemFields = new TreeItem(this.itemInput, 0);
                    itemFields.setImage(this.imageArrowOrange);
                    itemFields.setText(strItemInToAdd);
                    itemFields.setData((Object)strItemInToAdd);
                    itemFields = new TreeItem(this.itemOutput, 0);
                    itemFields.setImage(this.imageArrowOrange);
                    itemFields.setText(strItemToAddOut);
                    itemFields.setData((Object)strItemToAddOut);
                }
                for (i = 0; i < this.wFields.nrNonEmpty(); ++i) {
                    TableItem item = this.wFields.getNonEmpty(i);
                    String fieldName = item.getText(1);
                    String renameField = item.getText(2);
                    strItemToAddOut = StringUtils.isEmpty((String)renameField) ? fieldName : renameField;
                    TreeItem itemFields = new TreeItem(this.itemOutput, 0);
                    itemFields.setImage(this.imageArrowOrange);
                    itemFields.setText(strItemToAddOut);
                    itemFields.setData((Object)strItemToAddOut);
                }
            }
        });
    }

    private void buildingFolderMenu() {
        MenuItem addNewItem = new MenuItem(this.cMenu, 8);
        addNewItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.AddNewTab", (String[])new String[0]));
        addNewItem.addListener(13, e -> this.addCTab("", "", 1));
        MenuItem copyItem = new MenuItem(this.cMenu, 8);
        copyItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.AddCopy", (String[])new String[0]));
        copyItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            StyledTextComp st = (StyledTextComp)item.getControl();
            this.addCTab(item.getText(), st.getText(), 2);
        });
        new MenuItem(this.cMenu, 2);
        MenuItem setActiveScriptItem = new MenuItem(this.cMenu, 8);
        setActiveScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.SetTransformScript", (String[])new String[0]));
        setActiveScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                        this.strActiveStartScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                        this.strActiveEndScript = "";
                    }
                    item.setImage(this.imageActiveScript);
                    this.strActiveScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyScriptTree(item, 3);
        });
        MenuItem setStartScriptItem = new MenuItem(this.cMenu, 8);
        setStartScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.SetStartScript", (String[])new String[0]));
        setStartScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                        this.strActiveStartScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                        this.strActiveEndScript = "";
                    }
                    item.setImage(this.imageActiveStartScript);
                    this.strActiveStartScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveStartScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyScriptTree(item, 3);
        });
        MenuItem setEndScriptItem = new MenuItem(this.cMenu, 8);
        setEndScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.SetEndScript", (String[])new String[0]));
        setEndScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            for (int i = 0; i < this.folder.getItemCount(); ++i) {
                if (this.folder.getItem(i).equals(item)) {
                    if (item.getImage().equals((Object)this.imageActiveScript)) {
                        this.strActiveScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                        this.strActiveStartScript = "";
                    } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                        this.strActiveEndScript = "";
                    }
                    item.setImage(this.imageActiveEndScript);
                    this.strActiveEndScript = item.getText();
                    continue;
                }
                if (!this.folder.getItem(i).getImage().equals((Object)this.imageActiveEndScript)) continue;
                this.folder.getItem(i).setImage(this.imageInactiveScript);
            }
            this.modifyScriptTree(item, 3);
        });
        new MenuItem(this.cMenu, 2);
        MenuItem setRemoveScriptItem = new MenuItem(this.cMenu, 8);
        setRemoveScriptItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.RemoveScriptType", (String[])new String[0]));
        setRemoveScriptItem.addListener(13, e -> {
            CTabItem item = this.folder.getSelection();
            this.input.setChanged(true);
            if (item.getImage().equals((Object)this.imageActiveScript)) {
                this.strActiveScript = "";
            } else if (item.getImage().equals((Object)this.imageActiveStartScript)) {
                this.strActiveStartScript = "";
            } else if (item.getImage().equals((Object)this.imageActiveEndScript)) {
                this.strActiveEndScript = "";
            }
            item.setImage(this.imageInactiveScript);
        });
        this.folder.setMenu(this.cMenu);
    }

    private void buildingTreeMenu() {
        MenuItem addDeleteItem = new MenuItem(this.tMenu, 8);
        addDeleteItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Delete.Label", (String[])new String[0]));
        addDeleteItem.addListener(13, e -> {
            if (this.wTree.getSelectionCount() <= 0) {
                return;
            }
            TreeItem tItem = this.wTree.getSelection()[0];
            if (tItem != null) {
                MessageBox messageBox = new MessageBox(this.shell, 196);
                messageBox.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.DeleteItem.Label", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString(PKG, (String)"ScriptDialog.ConfirmDeleteItem.Label", (String[])new String[]{tItem.getText()}));
                if (messageBox.open() == 64) {
                    this.modifyCTabItem(tItem, 0, "");
                    tItem.dispose();
                    this.input.setChanged();
                }
            }
        });
        MenuItem renItem = new MenuItem(this.tMenu, 8);
        renItem.setText(BaseMessages.getString(PKG, (String)"ScriptDialog.Rename.Label", (String[])new String[0]));
        renItem.addListener(13, e -> this.renameFunction(this.wTree.getSelection()[0]));
        this.wTree.addListener(3, e -> {
            if (this.wTree.getSelectionCount() <= 0) {
                return;
            }
            TreeItem tItem = this.wTree.getSelection()[0];
            if (tItem != null) {
                TreeItem pItem = tItem.getParentItem();
                if (pItem != null && pItem.equals(this.wTreeScriptsItem)) {
                    this.tMenu.getItem(0).setEnabled(this.folder.getItemCount() > 1);
                    this.tMenu.getItem(1).setEnabled(true);
                } else {
                    this.tMenu.getItem(0).setEnabled(false);
                    this.tMenu.getItem(1).setEnabled(false);
                }
            }
        });
        this.wTree.setMenu(this.tMenu);
    }

    private void addRenameToTreeScriptItems() {
        this.lastItem = new TreeItem[1];
        this.editor = new TreeEditor(this.wTree);
        this.wTree.addListener(13, event -> {
            TreeItem item = (TreeItem)event.item;
            this.renameFunction(item);
        });
    }

    private void renameFunction(TreeItem tItem) {
        TreeItem item = tItem;
        if (item != null && item.getParentItem() != null && item.getParentItem().equals(this.wTreeScriptsItem) && item == this.lastItem[0]) {
            boolean isCarbon = SWT.getPlatform().equals("carbon");
            Composite composite = new Composite((Composite)this.wTree, 0);
            if (!isCarbon) {
                composite.setBackground(this.shell.getDisplay().getSystemColor(2));
            }
            Text text = new Text(composite, 0);
            int inset = isCarbon ? 0 : 1;
            composite.addListener(11, e -> {
                Rectangle rect = composite.getClientArea();
                text.setBounds(rect.x + inset, rect.y + inset, rect.width - inset * 2, rect.height - inset * 2);
            });
            Listener textListener = e -> {
                block0 : switch (e.type) {
                    case 16: {
                        if (text.getText().length() > 0 && this.getCTabItemByName(text.getText()) == null) {
                            this.modifyCTabItem(item, 2, text.getText());
                            item.setText(text.getText());
                        }
                        composite.dispose();
                        break;
                    }
                    case 25: {
                        String newText = text.getText();
                        String leftText = newText.substring(0, e.start);
                        String rightText = newText.substring(e.end);
                        GC gc = new GC((Drawable)text);
                        Point size = gc.textExtent(leftText + e.text + rightText);
                        gc.dispose();
                        size = text.computeSize(size.x, -1);
                        this.editor.horizontalAlignment = 16384;
                        Rectangle itemRect = item.getBounds();
                        Rectangle rect = this.wTree.getClientArea();
                        this.editor.minimumWidth = Math.max(size.x, itemRect.width) + inset * 2;
                        int left = itemRect.x;
                        int right = rect.x + rect.width;
                        this.editor.minimumWidth = Math.min(this.editor.minimumWidth, right - left);
                        this.editor.minimumHeight = size.y + inset * 2;
                        this.editor.layout();
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                if (text.getText().length() <= 0 || this.getCTabItemByName(text.getText()) != null) break block0;
                                this.modifyCTabItem(item, 2, text.getText());
                                item.setText(text.getText());
                                break block0;
                            }
                            case 2: {
                                composite.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                        break;
                    }
                }
            };
            text.addListener(16, textListener);
            text.addListener(31, textListener);
            text.addListener(25, textListener);
            this.editor.setEditor((Control)composite, item);
            text.setText(item.getText());
            text.selectAll();
            text.setFocus();
        }
        this.lastItem[0] = item;
    }
}

