/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.splunkinput;

import com.splunk.Args;
import com.splunk.Event;
import com.splunk.JobResultsArgs;
import com.splunk.ResultsReaderXml;
import com.splunk.Service;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.splunkinput.ReturnValue;
import org.apache.hop.pipeline.transforms.splunkinput.SplunkInputData;
import org.apache.hop.pipeline.transforms.splunkinput.SplunkInputMeta;
import org.apache.hop.splunk.SplunkConnection;

public class SplunkInput
extends BaseTransform<SplunkInputMeta, SplunkInputData> {
    public SplunkInput(TransformMeta stepMeta, SplunkInputMeta meta, SplunkInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(stepMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        List transforms = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
        if (StringUtils.isEmpty((String)((SplunkInputMeta)this.meta).getConnectionName())) {
            this.log.logError("You need to specify a Splunk connection to use in this transform");
            return false;
        }
        String connectionName = this.resolve(((SplunkInputMeta)this.meta).getConnectionName());
        try {
            IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(SplunkConnection.class);
            if (!serializer.exists(connectionName)) {
                throw new HopException("The referenced Splunk connection with name '" + connectionName + "' does not exist in the metadata");
            }
            ((SplunkInputData)this.data).splunkConnection = (SplunkConnection)serializer.load(connectionName);
        }
        catch (HopException e) {
            this.log.logError("Could not load Splunk connection '" + ((SplunkInputMeta)this.meta).getConnectionName() + "' from the metastore", (Throwable)e);
            return false;
        }
        try {
            ((SplunkInputData)this.data).serviceArgs = ((SplunkInputData)this.data).splunkConnection.getServiceArgs((IVariables)this);
            ((SplunkInputData)this.data).service = Service.connect((Map)((SplunkInputData)this.data).serviceArgs);
        }
        catch (Exception e) {
            this.log.logError("Unable to get or create a connection to Splunk connection named '" + ((SplunkInputData)this.data).splunkConnection.getName() + "'", (Throwable)e);
            return false;
        }
        return super.init();
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            ((SplunkInputData)this.data).outputRowMeta = new RowMeta();
            ((SplunkInputMeta)this.meta).getFields(((SplunkInputData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            JobResultsArgs args = new JobResultsArgs();
            args.setCount(0);
            args.setOutputMode(JobResultsArgs.OutputMode.XML);
            ((SplunkInputData)this.data).eventsStream = ((SplunkInputData)this.data).service.oneshotSearch(this.resolve(((SplunkInputMeta)this.meta).getQuery()), (Args)args);
        }
        try {
            Event event;
            ResultsReaderXml resultsReader = new ResultsReaderXml(((SplunkInputData)this.data).eventsStream);
            while ((event = resultsReader.getNextEvent()) != null) {
                Object[] outputRow = RowDataUtil.allocateRowData((int)((SplunkInputData)this.data).outputRowMeta.size());
                for (int i = 0; i < ((SplunkInputMeta)this.meta).getReturnValues().size(); ++i) {
                    ReturnValue returnValue = ((SplunkInputMeta)this.meta).getReturnValues().get(i);
                    String value = (String)event.get(returnValue.getSplunkName());
                    outputRow[i] = value;
                }
                this.incrementLinesInput();
                this.putRow(((SplunkInputData)this.data).outputRowMeta, outputRow);
            }
        }
        catch (Exception e) {
            throw new HopException("Error reading from Splunk events stream", (Throwable)e);
        }
        finally {
            try {
                ((SplunkInputData)this.data).eventsStream.close();
            }
            catch (IOException e) {
                throw new HopException("Unable to close events stream", (Throwable)e);
            }
        }
        this.setOutputDone();
        return false;
    }
}

