/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableinput;

import java.sql.SQLException;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.tableinput.TableInputData;
import org.apache.hop.pipeline.transforms.tableinput.TableInputMeta;

public class TableInput
extends BaseTransform<TableInputMeta, TableInputData> {
    private static final Class<?> PKG = TableInputMeta.class;

    public TableInput(TransformMeta transformMeta, TableInputMeta meta, TableInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private RowMetaAndData readStartDate() throws HopException {
        if (this.log.isDetailed()) {
            this.logDetailed("Reading from transform [" + ((TableInputData)this.data).infoStream.getTransformName() + "]");
        }
        RowMeta parametersMeta = new RowMeta();
        Object[] parametersData = new Object[]{};
        IRowSet rowSet = this.findInputRowSet(((TableInputData)this.data).infoStream.getTransformName());
        if (rowSet != null) {
            Object[] rowData = this.getRowFrom(rowSet);
            while (rowData != null) {
                parametersData = RowDataUtil.addRowData((Object[])parametersData, (int)parametersMeta.size(), (Object[])rowData);
                parametersMeta.addRowMeta(rowSet.getRowMeta());
                rowData = this.getRowFrom(rowSet);
            }
            if (parametersMeta.size() == 0) {
                throw new HopException("Expected to read parameters from transform [" + ((TableInputData)this.data).infoStream.getTransformName() + "] but none were found.");
            }
        } else {
            throw new HopException("Unable to find rowset to read from, perhaps transform [" + ((TableInputData)this.data).infoStream.getTransformName() + "] doesn't exist. (or perhaps you are trying a preview?)");
        }
        RowMetaAndData parameters = new RowMetaAndData((IRowMeta)parametersMeta, parametersData);
        return parameters;
    }

    public boolean processRow() throws HopException {
        boolean success;
        if (this.first) {
            RowMeta parametersMeta;
            Object[] parameters;
            this.first = false;
            if (((TableInputData)this.data).infoStream.getTransformMeta() != null) {
                if (((TableInputMeta)this.meta).isExecuteEachInputRow()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Reading single row from stream [" + ((TableInputData)this.data).infoStream.getTransformName() + "]");
                    }
                    ((TableInputData)this.data).rowSet = this.findInputRowSet(((TableInputData)this.data).infoStream.getTransformName());
                    if (((TableInputData)this.data).rowSet == null) {
                        throw new HopException("Unable to find rowset to read from, perhaps transform [" + ((TableInputData)this.data).infoStream.getTransformName() + "] doesn't exist. (or perhaps you are trying a preview?)");
                    }
                    parameters = this.getRowFrom(((TableInputData)this.data).rowSet);
                    parametersMeta = ((TableInputData)this.data).rowSet.getRowMeta();
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Reading query parameters from stream [" + ((TableInputData)this.data).infoStream.getTransformName() + "]");
                    }
                    RowMetaAndData rmad = this.readStartDate();
                    parameters = rmad.getData();
                    parametersMeta = rmad.getRowMeta();
                }
                if (parameters != null && this.log.isDetailed()) {
                    this.logDetailed("Query parameters found = " + parametersMeta.getString(parameters));
                }
            } else {
                parameters = new Object[]{};
                parametersMeta = new RowMeta();
            }
            if (((TableInputMeta)this.meta).isExecuteEachInputRow() && (parameters == null || parametersMeta.size() == 0)) {
                this.setOutputDone();
                return false;
            }
            success = this.doQuery((IRowMeta)parametersMeta, parameters);
            if (!success) {
                return false;
            }
        } else if (((TableInputData)this.data).thisrow != null) {
            try {
                ((TableInputData)this.data).nextrow = ((TableInputData)this.data).db.getRow(((TableInputData)this.data).rs, false);
            }
            catch (HopDatabaseException e) {
                if (e.getCause() instanceof SQLException && this.isStopped()) {
                    this.logDebug(e.getMessage());
                    return false;
                }
                throw e;
            }
            if (((TableInputData)this.data).nextrow != null) {
                this.incrementLinesInput();
            }
        }
        if (((TableInputData)this.data).thisrow == null) {
            boolean done = false;
            if (((TableInputMeta)this.meta).isExecuteEachInputRow()) {
                Object[] nextRow = this.getRowFrom(((TableInputData)this.data).rowSet);
                if (nextRow == null) {
                    done = true;
                } else {
                    this.closePreviousQuery();
                    success = this.doQuery(((TableInputData)this.data).rowSet.getRowMeta(), nextRow);
                    if (!success) {
                        return false;
                    }
                    if (((TableInputData)this.data).thisrow != null) {
                        this.putRow(((TableInputData)this.data).rowMeta, ((TableInputData)this.data).thisrow);
                        ((TableInputData)this.data).thisrow = ((TableInputData)this.data).nextrow;
                        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                            this.logBasic("linenr " + this.getLinesInput());
                        }
                    }
                }
            } else {
                done = true;
            }
            if (done) {
                this.setOutputDone();
                return false;
            }
        } else {
            this.putRow(((TableInputData)this.data).rowMeta, ((TableInputData)this.data).thisrow);
            ((TableInputData)this.data).thisrow = ((TableInputData)this.data).nextrow;
            if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesInput());
            }
        }
        return true;
    }

    private void closePreviousQuery() throws HopDatabaseException {
        if (((TableInputData)this.data).db != null) {
            ((TableInputData)this.data).db.closeQuery(((TableInputData)this.data).rs);
        }
    }

    private boolean doQuery(IRowMeta parametersMeta, Object[] parameters) throws HopDatabaseException {
        boolean success = true;
        String sql = null;
        sql = ((TableInputMeta)this.meta).isVariableReplacementActive() ? this.resolve(((TableInputMeta)this.meta).getSql()) : ((TableInputMeta)this.meta).getSql();
        if (this.log.isDetailed()) {
            this.logDetailed("SQL query : " + sql);
        }
        ((TableInputData)this.data).rs = parametersMeta.isEmpty() ? ((TableInputData)this.data).db.openQuery(sql, null, null, 1000, false) : ((TableInputData)this.data).db.openQuery(sql, parametersMeta, parameters, 1000, false);
        if (((TableInputData)this.data).rs == null) {
            this.logError("Couldn't open Query [" + sql + "]");
            this.setErrors(1L);
            this.stopAll();
            success = false;
        } else {
            ((TableInputData)this.data).rowMeta = ((TableInputData)this.data).db.getReturnRowMeta();
            if (((TableInputData)this.data).rowMeta != null) {
                for (IValueMeta valueMeta : ((TableInputData)this.data).rowMeta.getValueMetaList()) {
                    valueMeta.setOrigin(this.getTransformName());
                }
            }
            ((TableInputData)this.data).thisrow = ((TableInputData)this.data).db.getRow(((TableInputData)this.data).rs);
            if (((TableInputData)this.data).thisrow != null) {
                this.incrementLinesInput();
                ((TableInputData)this.data).nextrow = ((TableInputData)this.data).db.getRow(((TableInputData)this.data).rs);
                if (((TableInputData)this.data).nextrow != null) {
                    this.incrementLinesInput();
                }
            }
        }
        return success;
    }

    public void dispose() {
        if (this.log.isBasic()) {
            this.logBasic("Finished reading query, closing connection.");
        }
        try {
            this.closePreviousQuery();
        }
        catch (HopException e) {
            this.logError("Unexpected error closing query : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            if (((TableInputData)this.data).db != null) {
                ((TableInputData)this.data).db.disconnect();
                ((TableInputData)this.data).db = null;
            }
        }
        super.dispose();
    }

    public synchronized void stopRunning() throws HopException {
        if (this.isStopped() || ((TableInputData)this.data).isDisposed()) {
            return;
        }
        this.setStopped(true);
        if (((TableInputData)this.data).db != null && ((TableInputData)this.data).db.getConnection() != null && !((TableInputData)this.data).isCanceled) {
            ((TableInputData)this.data).db.cancelQuery();
            ((TableInputData)this.data).isCanceled = true;
        }
    }

    public boolean init() {
        if (super.init()) {
            boolean passed = true;
            if (Utils.isEmpty((CharSequence)((TableInputMeta)this.meta).getSql())) {
                this.logError(BaseMessages.getString(PKG, (String)"TableInput.Exception.SQLIsNeeded", (String[])new String[0]));
                passed = false;
            }
            if (((TableInputMeta)this.meta).getConnection() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"TableInput.Exception.DatabaseConnectionsIsNeeded", (String[])new String[0]));
                passed = false;
            }
            if (!passed) {
                return false;
            }
            ((TableInputData)this.data).infoStream = (IStream)((TableInputMeta)this.meta).getTransformIOMeta().getInfoStreams().get(0);
            if (((TableInputMeta)this.meta).getLookup() != null) {
                ((TableInputData)this.data).infoStream.setSubject(((TableInputMeta)this.meta).getLookup());
            }
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((TableInputMeta)this.meta).getConnection(), this.variables);
            ((TableInputData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
            ((TableInputData)this.data).db.setQueryLimit(Const.toInt((String)this.resolve(((TableInputMeta)this.meta).getRowLimit()), (int)0));
            try {
                ((TableInputData)this.data).db.connect();
                if (databaseMeta.isRequiringTransactionsOnQueries()) {
                    ((TableInputData)this.data).db.setCommit(100);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("Connected to database...");
                }
                return true;
            }
            catch (HopException e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public boolean isWaitingForData() {
        return true;
    }
}

