/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.value.DateTimeValue;

public class Numberer_en
implements Numberer,
Serializable {
    private String country;
    public static final int UPPER_CASE = 0;
    public static final int LOWER_CASE = 1;
    public static final int TITLE_CASE = 2;
    protected static final String westernDigits = "0123456789";
    protected static final String latinUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final String latinLower = "abcdefghijklmnopqrstuvwxyz";
    protected static final String greekUpper = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    protected static final String greekLower = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    protected static final String cyrillicUpper = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    protected static final String cyrillicLower = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    protected static final String hebrew = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    protected static final String hiraganaA = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    protected static final String katakanaA = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    protected static final String hiraganaI = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    protected static final String katakanaI = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    protected static final String kanjiDigits = "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
    private static String[] romanThousands = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static String[] romanHundreds = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static String[] romanTens = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static String[] romanUnits = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    private static String[] englishUnits = new String[]{"", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    private static String[] englishTens = new String[]{"", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};
    private static String[] englishOrdinalUnits = new String[]{"", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth"};
    private static String[] englishOrdinalTens = new String[]{"", "Tenth", "Twentieth", "Thirtieth", "Fortieth", "Fiftieth", "Sixtieth", "Seventieth", "Eightieth", "Ninetieth"};
    private static String[] englishMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String[] englishDays = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static String[] englishDayAbbreviations = new String[]{"Mon", "Tues", "Weds", "Thurs", "Fri", "Sat", "Sun"};
    private static int[] minUniqueDayLength = new int[]{2, 1, 2, 1, 2, 2, 1};
    static HashMap timezones = new HashMap(50);

    public void setCountry(String string) {
        this.country = string;
    }

    public String format(long l, String string, int n, String string2, String string3, String string4) {
        if (l < 0L) {
            return "" + l;
        }
        if (string == null || string.length() == 0) {
            return "" + l;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        char c = string.charAt(0);
        switch (c) {
            case '0': 
            case '1': {
                fastStringBuffer.append(this.toRadical(l, westernDigits, string, n, string2));
                if (string4 == null || string4.length() <= 0) break;
                fastStringBuffer.append(this.ordinalSuffix(string4, l));
                break;
            }
            case 'A': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, latinUpper));
                break;
            }
            case 'a': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, latinLower));
                break;
            }
            case 'W': 
            case 'w': {
                int n2 = string.equals("W") ? 0 : (string.equals("w") ? 1 : 2);
                if (string4 != null && string4.length() > 0) {
                    fastStringBuffer.append(this.toOrdinalWords(string4, l, n2));
                    break;
                }
                fastStringBuffer.append(this.toWords(l, n2));
                break;
            }
            case 'i': {
                if (l == 0L) {
                    return "0";
                }
                if (string3 == null || string3.equals("") || string3.equals("traditional")) {
                    fastStringBuffer.append(Numberer_en.toRoman(l));
                    break;
                }
                this.alphaDefault(l, c, fastStringBuffer);
                break;
            }
            case 'I': {
                if (l == 0L) {
                    return "0";
                }
                if (string3 == null || string3.equals("") || string3.equals("traditional")) {
                    fastStringBuffer.append(Numberer_en.toRoman(l).toUpperCase());
                    break;
                }
                this.alphaDefault(l, c, fastStringBuffer);
                break;
            }
            case '\u0391': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, greekUpper));
                break;
            }
            case '\u03b1': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, greekLower));
                break;
            }
            case '\u0410': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, cyrillicUpper));
                break;
            }
            case '\u0430': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, cyrillicLower));
                break;
            }
            case '\u05d0': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, hebrew));
                break;
            }
            case '\u3042': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, hiraganaA));
                break;
            }
            case '\u30a2': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, katakanaA));
                break;
            }
            case '\u3044': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, hiraganaI));
                break;
            }
            case '\u30a4': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toAlphaSequence(l, katakanaI));
                break;
            }
            case '\u4e00': {
                if (l == 0L) {
                    return "0";
                }
                fastStringBuffer.append(this.toRadical(l, kanjiDigits, string, n, string2));
                break;
            }
            default: {
                if (Character.isDigit(c)) {
                    int n3 = c - Character.getNumericValue(c);
                    String string5 = "" + (char)n3 + (char)(n3 + 1) + (char)(n3 + 2) + (char)(n3 + 3) + (char)(n3 + 4) + (char)(n3 + 5) + (char)(n3 + 6) + (char)(n3 + 7) + (char)(n3 + 8) + (char)(n3 + 9);
                    fastStringBuffer.append(this.toRadical(l, string5, string, n, string2));
                    break;
                }
                if (l == 0L) {
                    return "0";
                }
                if (c < '\u1100') {
                    this.alphaDefault(l, c, fastStringBuffer);
                    break;
                }
                fastStringBuffer.append(this.toRadical(l, westernDigits, string, n, string2));
            }
        }
        return fastStringBuffer.toString();
    }

    protected String ordinalSuffix(String string, long l) {
        int n = (int)(l % 100L) / 10;
        int n2 = (int)(l % 10L);
        if (n == 1) {
            return "th";
        }
        if (n2 == 1) {
            return "st";
        }
        if (n2 == 2) {
            return "nd";
        }
        if (n2 == 3) {
            return "rd";
        }
        return "th";
    }

    protected void alphaDefault(long l, char n, FastStringBuffer fastStringBuffer) {
        int n2 = n;
        int n3 = n;
        while (Character.isLetterOrDigit((char)(n3 + '\u0001'))) {
            ++n3;
        }
        fastStringBuffer.append(this.toAlpha(l, n2, n3));
    }

    protected String toAlpha(long l, int n, int n2) {
        if (l <= 0L) {
            return "" + l;
        }
        int n3 = n2 - n + 1;
        char c = (char)((l - 1L) % (long)n3 + (long)n);
        if (l > (long)n3) {
            return this.toAlpha((l - 1L) / (long)n3, n, n2) + c;
        }
        return "" + c;
    }

    protected String toAlphaSequence(long l, String string) {
        if (l <= 0L) {
            return "" + l;
        }
        int n = string.length();
        char c = string.charAt((int)((l - 1L) % (long)n));
        if (l > (long)n) {
            return this.toAlphaSequence((l - 1L) / (long)n, string) + c;
        }
        return "" + c;
    }

    private String toRadical(long l, String string, String string2, int n, String string3) {
        int n2;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(16);
        int n3 = string.length();
        String string4 = "";
        for (long i = l; i > 0L; i /= (long)n3) {
            string4 = string.charAt((int)(i % (long)n3)) + string4;
        }
        for (n2 = 0; n2 < string2.length() - string4.length(); ++n2) {
            fastStringBuffer2.append(string.charAt(0));
        }
        fastStringBuffer2.append(string4);
        if (n > 0) {
            for (n2 = 0; n2 < fastStringBuffer2.length(); ++n2) {
                if (n2 != 0 && (fastStringBuffer2.length() - n2) % n == 0) {
                    fastStringBuffer.append(string3);
                }
                fastStringBuffer.append(fastStringBuffer2.charAt(n2));
            }
        } else {
            fastStringBuffer = fastStringBuffer2;
        }
        return fastStringBuffer.toString();
    }

    public static String toRoman(long l) {
        if (l <= 0L || l > 9999L) {
            return "" + l;
        }
        return romanThousands[(int)l / 1000] + romanHundreds[(int)l / 100 % 10] + romanTens[(int)l / 10 % 10] + romanUnits[(int)l % 10];
    }

    public String toWords(long l) {
        if (l >= 1000000000L) {
            long l2 = l % 1000000000L;
            return this.toWords(l / 1000000000L) + " Billion" + (l2 == 0L ? "" : (l2 < 100L ? " and " : " ") + this.toWords(l2));
        }
        if (l >= 1000000L) {
            long l3 = l % 1000000L;
            return this.toWords(l / 1000000L) + " Million" + (l3 == 0L ? "" : (l3 < 100L ? " and " : " ") + this.toWords(l3));
        }
        if (l >= 1000L) {
            long l4 = l % 1000L;
            return this.toWords(l / 1000L) + " Thousand" + (l4 == 0L ? "" : (l4 < 100L ? " and " : " ") + this.toWords(l4));
        }
        if (l >= 100L) {
            long l5 = l % 100L;
            return this.toWords(l / 100L) + " Hundred" + (l5 == 0L ? "" : " and " + this.toWords(l5));
        }
        if (l < 20L) {
            return englishUnits[(int)l];
        }
        int n = (int)(l % 10L);
        return englishTens[(int)l / 10] + (n == 0 ? "" : ' ' + englishUnits[n]);
    }

    public String toWords(long l, int n) {
        String string = l == 0L ? "Zero" : this.toWords(l);
        if (n == 0) {
            return string.toUpperCase();
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    public String toOrdinalWords(String string, long l, int n) {
        String string2;
        if (l >= 1000000000L) {
            long l2 = l % 1000000000L;
            string2 = this.toWords(l / 1000000000L) + " Billion" + (l2 == 0L ? "th" : (l2 < 100L ? " and " : " ") + this.toOrdinalWords(string, l2, n));
        } else if (l >= 1000000L) {
            long l3 = l % 1000000L;
            string2 = this.toWords(l / 1000000L) + " Million" + (l3 == 0L ? "th" : (l3 < 100L ? " and " : " ") + this.toOrdinalWords(string, l3, n));
        } else if (l >= 1000L) {
            long l4 = l % 1000L;
            string2 = this.toWords(l / 1000L) + " Thousand" + (l4 == 0L ? "th" : (l4 < 100L ? " and " : " ") + this.toOrdinalWords(string, l4, n));
        } else if (l >= 100L) {
            long l5 = l % 100L;
            string2 = this.toWords(l / 100L) + " Hundred" + (l5 == 0L ? "th" : " and " + this.toOrdinalWords(string, l5, n));
        } else {
            int n2;
            string2 = l < 20L ? englishOrdinalUnits[(int)l] : ((n2 = (int)(l % 10L)) == 0 ? englishOrdinalTens[(int)l / 10] : englishTens[(int)l / 10] + '-' + englishOrdinalUnits[n2]);
        }
        if (n == 0) {
            return string2.toUpperCase();
        }
        if (n == 1) {
            return string2.toLowerCase();
        }
        return string2;
    }

    public String monthName(int n, int n2, int n3) {
        String string = englishMonths[n - 1];
        if (n3 < 3) {
            n3 = 3;
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        while (string.length() < n2) {
            string = string + ' ';
        }
        return string;
    }

    public String dayName(int n, int n2, int n3) {
        String string = englishDays[n - 1];
        if (n3 < 2) {
            n3 = 2;
        }
        if (string.length() > n3 && (string = englishDayAbbreviations[n - 1]).length() > n3) {
            string = string.substring(0, n3);
        }
        while (string.length() < n2) {
            string = string + ' ';
        }
        if (n2 == 1 && n3 == 2) {
            string = string.substring(0, minUniqueDayLength[n - 1]);
        }
        return string;
    }

    public String halfDayName(int n, int n2, int n3) {
        String string;
        if (n < 720) {
            switch (n3) {
                case 1: {
                    string = "A";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Am";
                    break;
                }
                default: {
                    string = "A.M.";
                    break;
                }
            }
        } else {
            switch (n3) {
                case 1: {
                    string = "P";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Pm";
                    break;
                }
                default: {
                    string = "P.M.";
                }
            }
        }
        return string;
    }

    public String getOrdinalSuffixForDateTime(String string) {
        return "yes";
    }

    public String getEraName(int n) {
        return n > 0 ? "AD" : "BC";
    }

    public String getTimezoneName(int n) {
        String string;
        List list = (List)timezones.get(new Integer(n));
        if (list == null) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(10);
            DateTimeValue.appendTimezone(n, fastStringBuffer);
            return fastStringBuffer.toString();
        }
        String string2 = string = this.country == null ? "us" : this.country;
        if (list.size() == 1) {
            return ((String[])list.get(0))[0];
        }
        for (int i = 0; i < list.size(); ++i) {
            String[] stringArray = (String[])list.get(i);
            if (!stringArray[1].equals(string)) continue;
            return stringArray[0];
        }
        return ((String[])list.get(0))[0];
    }

    static void tz(double d, String string, String string2) {
        Integer n = new Integer((int)(d * 60.0));
        String[] stringArray = new String[]{string, string2};
        ArrayList<String[]> arrayList = (ArrayList<String[]>)timezones.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<String[]>(3);
        }
        arrayList.add(stringArray);
        timezones.put(n, arrayList);
    }

    static {
        Numberer_en.tz(9.5, "ACST", "au");
        Numberer_en.tz(10.0, "AEST", "au");
        Numberer_en.tz(-9.0, "AKST", "us");
        Numberer_en.tz(8.0, "AWST", "au");
        Numberer_en.tz(1.0, "BST", "gb");
        Numberer_en.tz(1.0, "CET", "eu");
        Numberer_en.tz(9.5, "CST", "au");
        Numberer_en.tz(-6.0, "CST", "us");
        Numberer_en.tz(7.0, "CXT", "au");
        Numberer_en.tz(2.0, "EET", "eu");
        Numberer_en.tz(10.0, "EST", "au");
        Numberer_en.tz(-5.0, "EST", "us");
        Numberer_en.tz(0.0, "GMT", "gb");
        Numberer_en.tz(-10.0, "HAST", "us");
        Numberer_en.tz(1.0, "MEZ", "de");
        Numberer_en.tz(-7.0, "MST", "us");
        Numberer_en.tz(11.5, "NFT", "au");
        Numberer_en.tz(-3.5, "NST", "us");
        Numberer_en.tz(-8.0, "PST", "us");
        Numberer_en.tz(0.0, "UTC", "eu");
        Numberer_en.tz(0.0, "WET", "eu");
        Numberer_en.tz(8.0, "WST", "au");
        Numberer_en.tz(10.5, "ACDT", "au*");
        Numberer_en.tz(-3.0, "ADT", "us*");
        Numberer_en.tz(11.0, "AEDT", "au*");
        Numberer_en.tz(-8.0, "AKDT", "us*");
        Numberer_en.tz(-4.0, "AST", "us*");
        Numberer_en.tz(10.5, "CDT", "au*");
        Numberer_en.tz(-5.0, "CDT", "us*");
        Numberer_en.tz(2.0, "CEDT", "eu*");
        Numberer_en.tz(11.0, "EDT", "au*");
        Numberer_en.tz(-4.0, "EDT", "us*");
        Numberer_en.tz(3.0, "EEDT", "eu*");
        Numberer_en.tz(-6.0, "MDT", "us*");
        Numberer_en.tz(2.0, "MESZ", "de*");
        Numberer_en.tz(-2.5, "NDT", "us*");
        Numberer_en.tz(-7.0, "PDT", "us*");
        Numberer_en.tz(1.0, "WEDT", "eu*");
    }
}

