/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;

final class DeltaBaseCache {
    private static final int TABLE_BITS = 10;
    private static final int MASK_BITS = 22;
    private int maxByteCount;
    private int curByteCount;
    private final Entry[] table;
    private Entry lruHead;
    private Entry lruTail;

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    DeltaBaseCache(DfsReader reader) {
        this(reader.getOptions().getDeltaBaseCacheLimit());
    }

    DeltaBaseCache(int maxBytes) {
        this.maxByteCount = maxBytes;
        this.table = new Entry[1024];
    }

    Entry get(DfsStreamKey key, long position) {
        Entry e = this.table[DeltaBaseCache.hash(position)];
        while (e != null) {
            if (e.offset == position && key.equals(e.pack)) {
                this.moveToHead(e);
                return e;
            }
            e = e.tableNext;
        }
        return null;
    }

    void put(DfsStreamKey key, long offset, int objectType, byte[] data) {
        if (data.length > this.maxByteCount) {
            return;
        }
        this.curByteCount += data.length;
        this.releaseMemory();
        int tableIdx = DeltaBaseCache.hash(offset);
        Entry e = new Entry(key, offset, objectType, data);
        e.tableNext = this.table[tableIdx];
        this.table[tableIdx] = e;
        this.lruPushHead(e);
    }

    private void releaseMemory() {
        while (this.curByteCount > this.maxByteCount && this.lruTail != null) {
            Entry e = this.lruTail;
            this.curByteCount -= e.data.length;
            this.lruRemove(e);
            this.removeFromTable(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeFromTable(Entry e) {
        tableIdx = DeltaBaseCache.hash(e.offset);
        p = this.table[tableIdx];
        if (p != e) ** GOTO lbl10
        this.table[tableIdx] = e.tableNext;
        return;
lbl-1000:
        // 1 sources

        {
            if (p.tableNext == e) {
                p.tableNext = e.tableNext;
                return;
            }
            p = p.tableNext;
lbl10:
            // 2 sources

            ** while (p != null)
        }
lbl11:
        // 1 sources

        throw new IllegalStateException(String.format("entry for %s:%d not in table", new Object[]{e.pack, e.offset}));
    }

    private void moveToHead(Entry e) {
        if (e != this.lruHead) {
            this.lruRemove(e);
            this.lruPushHead(e);
        }
    }

    private void lruRemove(Entry e) {
        Entry p = e.lruPrev;
        Entry n = e.lruNext;
        if (p != null) {
            p.lruNext = n;
        } else {
            this.lruHead = n;
        }
        if (n != null) {
            n.lruPrev = p;
        } else {
            this.lruTail = p;
        }
    }

    private void lruPushHead(Entry e) {
        Entry n;
        e.lruNext = n = this.lruHead;
        if (n != null) {
            n.lruPrev = e;
        } else {
            this.lruTail = e;
        }
        e.lruPrev = null;
        this.lruHead = e;
    }

    int getMemoryUsed() {
        return this.curByteCount;
    }

    int getMemoryUsedByLruChainForTest() {
        int r = 0;
        Entry e = this.lruHead;
        while (e != null) {
            r += e.data.length;
            e = e.lruNext;
        }
        return r;
    }

    int getMemoryUsedByTableForTest() {
        int r = 0;
        int i = 0;
        while (i < this.table.length) {
            Entry e = this.table[i];
            while (e != null) {
                r += e.data.length;
                e = e.tableNext;
            }
            ++i;
        }
        return r;
    }

    static class Entry {
        final DfsStreamKey pack;
        final long offset;
        final int type;
        final byte[] data;
        Entry tableNext;
        Entry lruPrev;
        Entry lruNext;

        Entry(DfsStreamKey key, long offset, int type, byte[] data) {
            this.pack = key;
            this.offset = offset;
            this.type = type;
            this.data = data;
        }
    }
}

