/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.run;

import java.io.IOException;
import java.io.InputStream;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.Validation;
import org.apache.commons.io.IOUtils;
import org.apache.hop.beam.pipeline.HopPipelineMetaToBeamPipelineConverter;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;

public class MainDataflowTemplate {
    public static final String EXPERIMENT_APACHE_HOP_PIPELINE = "apache_hop_pipeline";

    public static void main(String[] args) {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        System.out.println(">>>>>>");
        System.out.println(options.toString());
        try {
            HopEnvironment.init();
            String pipelineMetaXml = MainDataflowTemplate.readFileIntoString(options.getHopPipelineLocation(), "UTF-8");
            String metadataJson = MainDataflowTemplate.readFileIntoString(options.getHopMetadataLocation(), "UTF-8");
            IVariables variables = Variables.getADefaultVariableSpace();
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metadataJson);
            System.out.println(">>>>>> Loading pipeline metadata");
            PipelineMeta pipelineMeta = new PipelineMeta(XmlHandler.loadXmlString((String)pipelineMetaXml, (String)"pipeline"), (IHopMetadataProvider)metadataProvider);
            HopPipelineMetaToBeamPipelineConverter hopPipelineMetaToBeamPipelineConverter = new HopPipelineMetaToBeamPipelineConverter(variables, pipelineMeta, (IHopMetadataProvider)metadataProvider, (PipelineOptions)options, null, null);
            Pipeline pipeline = hopPipelineMetaToBeamPipelineConverter.createPipeline();
            pipeline.run();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private static String readFileIntoString(String filename, String encoding) throws IOException {
        String string;
        block8: {
            InputStream inputStream = HopVfs.getInputStream((String)filename);
            try {
                string = IOUtils.toString((InputStream)inputStream, (String)encoding);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Error reading from file " + filename, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static interface Options
    extends StreamingOptions {
        @Description(value="Google Storage location with the Hop Metadata")
        @Validation.Required
        public String getHopMetadataLocation();

        public void setHopMetadataLocation(String var1);

        @Description(value="Google Storage location of the pipeline you want to start")
        @Validation.Required
        public String getHopPipelineLocation();

        public void setHopPipelineLocation(String var1);
    }
}

