/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.dataflow;

import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.hop.beam.engines.BeamPipelineEngine;
import org.apache.hop.beam.engines.dataflow.BeamDataFlowPipelineRunConfiguration;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateBuilder;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEnginePlugin;

@PipelineEnginePlugin(id="BeamDataFlowPipelineEngine", name="Beam DataFlow pipeline engine", description="This allows you to run your pipeline on Google Cloud Platform DataFlow, provided by the Apache Beam community")
@GuiPlugin
public class BeamDataFlowPipelineEngine
extends BeamPipelineEngine
implements IPipelineEngine<PipelineMeta> {
    public static final String DETAIL_DATAFLOW_JOB_ID = "dataflow.job.id";
    public static final String DETAIL_DATAFLOW_PROJECT_ID = "dataflow.project.id";
    public static final String DETAIL_DATAFLOW_REGION = "dataflow.region";

    @Override
    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration() {
        BeamDataFlowPipelineRunConfiguration runConfiguration = new BeamDataFlowPipelineRunConfiguration();
        runConfiguration.setUserAgent("Hop");
        return runConfiguration;
    }

    @Override
    public void validatePipelineRunConfigurationClass(IPipelineEngineRunConfiguration engineRunConfiguration) throws HopException {
        if (!(engineRunConfiguration instanceof BeamDataFlowPipelineRunConfiguration)) {
            throw new HopException("A Beam Direct pipeline engine needs a direct run configuration, not of class " + engineRunConfiguration.getClass().getName());
        }
    }

    @Override
    protected void updatePipelineState(IExecutionInfoLocation iLocation) throws HopException {
        ExecutionState executionState = ExecutionStateBuilder.fromExecutor((IPipelineEngine)this, (Integer)-1).build();
        if (this.beamPipelineResults != null) {
            DataflowPipelineJob dataflowPipelineJob = (DataflowPipelineJob)this.beamPipelineResults;
            executionState.getDetails().put(DETAIL_DATAFLOW_JOB_ID, dataflowPipelineJob.getJobId());
            executionState.getDetails().put(DETAIL_DATAFLOW_PROJECT_ID, dataflowPipelineJob.getProjectId());
            executionState.getDetails().put(DETAIL_DATAFLOW_REGION, dataflowPipelineJob.getRegion());
        }
        iLocation.updateExecutionState(executionState);
        for (IEngineComponent component : this.getComponents()) {
            ExecutionState transformState = ExecutionStateBuilder.fromTransform((IPipelineEngine)this, (IEngineComponent)component).build();
            iLocation.updateExecutionState(transformState);
        }
    }
}

