/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubLiteReadSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubLiteReadSchemaTransformConfiguration> {
    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration> configurationClass() {
        return PubsubLiteReadSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(final @UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration configuration) {
        org.apache.beam.sdk.schemas.Schema beamSchema = Objects.equals(configuration.getDataFormat(), "JSON") ? JsonUtils.beamSchemaFromJsonSchema((String)configuration.getSchema()) : AvroUtils.toBeamSchema((Schema)new Schema.Parser().parse(configuration.getSchema()));
        SimpleFunction valueMapper = Objects.equals(configuration.getDataFormat(), "JSON") ? JsonUtils.getJsonBytesToRowFunction((org.apache.beam.sdk.schemas.Schema)beamSchema) : AvroUtils.getAvroBytesToRowFunction((org.apache.beam.sdk.schemas.Schema)beamSchema);
        return new SchemaTransform((SerializableFunction)valueMapper, beamSchema){
            final /* synthetic */ SerializableFunction val$valueMapper;
            final /* synthetic */ org.apache.beam.sdk.schemas.Schema val$beamSchema;
            {
                this.val$valueMapper = serializableFunction;
                this.val$beamSchema = schema;
            }

            public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
                return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                        String project = configuration.getProject();
                        if (Strings.isNullOrEmpty((String)project)) {
                            project = ((GcpOptions)input.getPipeline().getOptions().as(GcpOptions.class)).getProject();
                        }
                        if (project == null) {
                            throw new IllegalArgumentException("Unable to infer the project to read from Pubsub Lite. Please provide a project.");
                        }
                        return PCollectionRowTuple.of((String)"output", (PCollection)((PCollection)((PCollection)input.getPipeline().apply(PubsubLiteIO.read(SubscriberOptions.newBuilder().setSubscriptionPath(((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setLocation(CloudRegionOrZone.parse((String)configuration.getLocation()))).setProject(ProjectId.of((String)project))).setName(SubscriptionName.of((String)configuration.getSubscriptionName())).build()).build()))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)seqMess -> (Row)val$valueMapper.apply((Object)seqMess.getMessage().getData().toByteArray())))).setRowSchema(val$beamSchema));
                    }
                };
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsublite_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("output");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class PubsubLiteReadSchemaTransformConfiguration {
        public abstract @UnknownKeyFor @NonNull @Initialized String getDataFormat();

        public abstract @UnknownKeyFor @NonNull @Initialized String getSchema();

        public abstract @Nullable @UnknownKeyFor @Initialized String getProject();

        public abstract @UnknownKeyFor @NonNull @Initialized String getSubscriptionName();

        public abstract @UnknownKeyFor @NonNull @Initialized String getLocation();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setDataFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProject(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriptionName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration build();
        }
    }
}

