/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgpdecryptstream;

import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgpdecryptstream.PGPDecryptStreamData;
import org.apache.hop.pipeline.transforms.pgpdecryptstream.PGPDecryptStreamMeta;
import org.apache.hop.workflow.actions.pgpencryptfiles.GPG;

public class PGPDecryptStream
extends BaseTransform<PGPDecryptStreamMeta, PGPDecryptStreamData> {
    private static final Class<?> PKG = PGPDecryptStreamMeta.class;

    public PGPDecryptStream(TransformMeta transformMeta, PGPDecryptStreamMeta meta, PGPDecryptStreamData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block18: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                String encryptedData;
                if (this.first) {
                    this.first = false;
                    ((PGPDecryptStreamData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                    ((PGPDecryptStreamData)this.data).NrPrevFields = ((PGPDecryptStreamData)this.data).previousRowMeta.size();
                    ((PGPDecryptStreamData)this.data).outputRowMeta = ((PGPDecryptStreamData)this.data).previousRowMeta;
                    ((PGPDecryptStreamMeta)this.meta).getFields(((PGPDecryptStreamData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    if (Utils.isEmpty((CharSequence)((PGPDecryptStreamMeta)this.meta).getStreamField())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.DataStreamFieldMissing", (String[])new String[0]));
                    }
                    if (((PGPDecryptStreamMeta)this.meta).isPassphraseFromField()) {
                        String fieldname = ((PGPDecryptStreamMeta)this.meta).getPassphraseFieldName();
                        if (Utils.isEmpty((CharSequence)fieldname)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.PassphraseFieldMissing", (String[])new String[0]));
                        }
                        ((PGPDecryptStreamData)this.data).indexOfPassphraseField = ((PGPDecryptStreamData)this.data).previousRowMeta.indexOfValue(fieldname);
                        if (((PGPDecryptStreamData)this.data).indexOfPassphraseField < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Exception.CouldnotFindField", (String[])new String[]{fieldname}));
                        }
                    } else {
                        ((PGPDecryptStreamData)this.data).passPhrase = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((PGPDecryptStreamMeta)this.meta).getPassphrase()));
                        if (Utils.isEmpty((CharSequence)((PGPDecryptStreamData)this.data).passPhrase)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.PassphraseMissing", (String[])new String[0]));
                        }
                    }
                    if (((PGPDecryptStreamData)this.data).indexOfField < 0) {
                        ((PGPDecryptStreamData)this.data).indexOfField = ((PGPDecryptStreamData)this.data).previousRowMeta.indexOfValue(((PGPDecryptStreamMeta)this.meta).getStreamField());
                        if (((PGPDecryptStreamData)this.data).indexOfField < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Exception.CouldnotFindField", (String[])new String[]{((PGPDecryptStreamMeta)this.meta).getStreamField()}));
                        }
                    }
                }
                Object[] outputRow = RowDataUtil.allocateRowData((int)((PGPDecryptStreamData)this.data).outputRowMeta.size());
                for (int i = 0; i < ((PGPDecryptStreamData)this.data).NrPrevFields; ++i) {
                    outputRow[i] = r[i];
                }
                if (((PGPDecryptStreamMeta)this.meta).isPassphraseFromField()) {
                    ((PGPDecryptStreamData)this.data).passPhrase = ((PGPDecryptStreamData)this.data).previousRowMeta.getString(r, ((PGPDecryptStreamData)this.data).indexOfPassphraseField);
                    if (Utils.isEmpty((CharSequence)((PGPDecryptStreamData)this.data).passPhrase)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.PassphraseMissing", (String[])new String[0]));
                    }
                }
                if (Utils.isEmpty((CharSequence)(encryptedData = ((PGPDecryptStreamData)this.data).previousRowMeta.getString(r, ((PGPDecryptStreamData)this.data).indexOfField)))) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.DataToDecryptEmpty", (String[])new String[0]));
                }
                String decryptedData = ((PGPDecryptStreamData)this.data).gpg.decrypt(encryptedData, ((PGPDecryptStreamData)this.data).passPhrase);
                outputRow[((PGPDecryptStreamData)this.data).NrPrevFields] = decryptedData;
                this.putRow(((PGPDecryptStreamData)this.data).outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"PGPDecryptStream.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"PGPDecryptStream.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((PGPDecryptStreamMeta)this.meta).getResultFieldName(), "PGPDecryptStreamO01");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((PGPDecryptStreamMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            try {
                ((PGPDecryptStreamData)this.data).gpg = new GPG(this.resolve(((PGPDecryptStreamMeta)this.meta).getGPGLocation()), this.log);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"PGPDecryptStream.Init.Error", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }
}

