/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class SchemaRegistryClientConfig {
    public static final String CLIENT_NAMESPACE = "schema.registry.";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE = "bearer.auth.credentials.source";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "bearer.auth.token";
    public static final String PROXY_HOST = "proxy.host";
    public static final String PROXY_PORT = "proxy.port";
    public static final String MISSING_CACHE_SIZE_CONFIG = "missing.cache.size";
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "missing.id.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_CONFIG = "missing.schema.cache.ttl.sec";

    public static void withClientSslSupport(ConfigDef configDef, String namespace) {
        ConfigDef sslConfigDef = new ConfigDef();
        sslConfigDef.withClientSslSupport();
        for (ConfigDef.ConfigKey configKey : sslConfigDef.configKeys().values()) {
            configDef.define(namespace + configKey.name, SchemaRegistryClientConfig.typeFor(configKey.type), configKey.defaultValue, SchemaRegistryClientConfig.importanceFor(configKey.importance), configKey.documentation);
        }
    }

    private static ConfigDef.Type typeFor(ConfigDef.Type type) {
        return ConfigDef.Type.valueOf((String)type.name());
    }

    private static ConfigDef.Importance importanceFor(ConfigDef.Importance importance) {
        return ConfigDef.Importance.valueOf((String)importance.name());
    }

    public static long getMissingIdTTL(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_ID_CACHE_TTL_CONFIG) ? (Long)configs.get(MISSING_ID_CACHE_TTL_CONFIG) : 0L;
    }

    public static long getMissingSchemaTTL(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_SCHEMA_CACHE_TTL_CONFIG) ? (Long)configs.get(MISSING_SCHEMA_CACHE_TTL_CONFIG) : 0L;
    }

    public static int getMaxMissingCacheSize(Map<String, ?> configs) {
        return configs != null && configs.containsKey(MISSING_CACHE_SIZE_CONFIG) ? (Integer)configs.get(MISSING_CACHE_SIZE_CONFIG) : 10000;
    }
}

