/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;

final class AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration
extends SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration {
    private final String instanceId;
    private final String databaseId;
    private final String tableId;
    private final String projectId;
    private final ErrorHandling errorHandling;

    private AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration(String instanceId, String databaseId, String tableId, @Nullable String projectId, @Nullable ErrorHandling errorHandling) {
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        this.tableId = tableId;
        this.projectId = projectId;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
    public String getDatabaseId() {
        return this.databaseId;
    }

    @Override
    @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
    public String getTableId() {
        return this.tableId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Specifies the GCP project.")
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Whether and how to handle write errors.")
    public ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "SpannerWriteSchemaTransformConfiguration{instanceId=" + this.instanceId + ", databaseId=" + this.databaseId + ", tableId=" + this.tableId + ", projectId=" + this.projectId + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration) {
            SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration that = (SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration)o;
            return this.instanceId.equals(that.getInstanceId()) && this.databaseId.equals(that.getDatabaseId()) && this.tableId.equals(that.getTableId()) && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.databaseId.hashCode();
        h$ *= 1000003;
        h$ ^= this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    static final class Builder
    extends SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration.Builder {
        private String instanceId;
        private String databaseId;
        private String tableId;
        private String projectId;
        private ErrorHandling errorHandling;

        Builder() {
        }

        @Override
        public SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration.Builder setInstanceId(String instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("Null instanceId");
            }
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration.Builder setDatabaseId(String databaseId) {
            if (databaseId == null) {
                throw new NullPointerException("Null databaseId");
            }
            this.databaseId = databaseId;
            return this;
        }

        @Override
        public SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration.Builder setTableId(String tableId) {
            if (tableId == null) {
                throw new NullPointerException("Null tableId");
            }
            this.tableId = tableId;
            return this;
        }

        @Override
        public SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration.Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public SpannerWriteSchemaTransformProvider.SpannerWriteSchemaTransformConfiguration build() {
            if (this.instanceId == null || this.databaseId == null || this.tableId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.instanceId == null) {
                    missing.append(" instanceId");
                }
                if (this.databaseId == null) {
                    missing.append(" databaseId");
                }
                if (this.tableId == null) {
                    missing.append(" tableId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerWriteSchemaTransformProvider_SpannerWriteSchemaTransformConfiguration(this.instanceId, this.databaseId, this.tableId, this.projectId, this.errorHandling);
        }
    }
}

