/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;

class RamDiskAsyncLazyPersistService {
    public static final Log LOG = LogFactory.getLog(RamDiskAsyncLazyPersistService.class);
    private static final int CORE_THREADS_PER_VOLUME = 1;
    private static final int MAXIMUM_THREADS_PER_VOLUME = 1;
    private static final long THREADS_KEEP_ALIVE_SECONDS = 60L;
    private final DataNode datanode;
    private final Configuration conf;
    private final ThreadGroup threadGroup;
    private Map<String, ThreadPoolExecutor> executors = new HashMap<String, ThreadPoolExecutor>();
    private static final HdfsConfiguration EMPTY_HDFS_CONF = new HdfsConfiguration();

    RamDiskAsyncLazyPersistService(DataNode datanode, Configuration conf) {
        this.datanode = datanode;
        this.conf = conf;
        this.threadGroup = new ThreadGroup(this.getClass().getSimpleName());
    }

    private void addExecutorForVolume(final String storageId) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(RamDiskAsyncLazyPersistService.this.threadGroup, r);
                t.setName("Async RamDisk lazy persist worker  for volume with id " + storageId);
                return t;
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        executor.allowCoreThreadTimeOut(true);
        this.executors.put(storageId, executor);
    }

    synchronized void addVolume(FsVolumeImpl volume) {
        String storageId = volume.getStorageID();
        if (this.executors == null) {
            throw new RuntimeException("AsyncLazyPersistService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(storageId);
        if (executor != null) {
            throw new RuntimeException("Volume " + volume + " is already existed.");
        }
        this.addExecutorForVolume(storageId);
    }

    synchronized void removeVolume(FsVolumeImpl volume) {
        String storageId = volume.getStorageID();
        if (this.executors == null) {
            throw new RuntimeException("AsyncDiskService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(storageId);
        if (executor == null) {
            throw new RuntimeException("Can not find volume with storage id " + storageId + " to remove.");
        }
        executor.shutdown();
        this.executors.remove(storageId);
    }

    synchronized boolean queryVolume(FsVolumeImpl volume) {
        String storageId = volume.getStorageID();
        if (this.executors == null) {
            throw new RuntimeException("AsyncLazyPersistService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(storageId);
        return executor != null;
    }

    synchronized void execute(String storageId, Runnable task) {
        if (this.executors == null) {
            throw new RuntimeException("AsyncLazyPersistService is already shutdown");
        }
        ThreadPoolExecutor executor = this.executors.get(storageId);
        if (executor == null) {
            throw new RuntimeException("Cannot find root storage volume with id " + storageId + " for execution of task " + task);
        }
        executor.execute(task);
    }

    synchronized void shutdown() {
        if (this.executors == null) {
            LOG.warn((Object)"AsyncLazyPersistService has already shut down.");
        } else {
            LOG.info((Object)"Shutting down all async lazy persist service threads");
            for (Map.Entry<String, ThreadPoolExecutor> e : this.executors.entrySet()) {
                e.getValue().shutdown();
            }
            this.executors = null;
            LOG.info((Object)"All async lazy persist service threads have been shut down");
        }
    }

    void submitLazyPersistTask(String bpId, long blockId, long genStamp, long creationTime, ReplicaInfo replica, FsVolumeReference target) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LazyWriter schedule async task to persist RamDisk block pool id: " + bpId + " block id: " + blockId));
        }
        ReplicaLazyPersistTask lazyPersistTask = new ReplicaLazyPersistTask(bpId, blockId, genStamp, creationTime, replica, target);
        FsVolumeImpl volume = (FsVolumeImpl)target.getVolume();
        this.execute(volume.getStorageID(), lazyPersistTask);
    }

    class ReplicaLazyPersistTask
    implements Runnable {
        private final String bpId;
        private final long blockId;
        private final long genStamp;
        private final long creationTime;
        private final ReplicaInfo replicaInfo;
        private final FsVolumeReference targetVolume;

        ReplicaLazyPersistTask(String bpId, long blockId, long genStamp, long creationTime, ReplicaInfo replicaInfo, FsVolumeReference targetVolume) {
            this.bpId = bpId;
            this.blockId = blockId;
            this.genStamp = genStamp;
            this.creationTime = creationTime;
            this.replicaInfo = replicaInfo;
            this.targetVolume = targetVolume;
        }

        public String toString() {
            return "LazyWriter async task of persist RamDisk block pool id:" + this.bpId + " block pool id: " + this.blockId + " with block file " + this.replicaInfo.getBlockURI() + " and meta file " + this.replicaInfo.getMetadataURI() + " to target volume " + this.targetVolume;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean succeeded = false;
            FsDatasetImpl dataset = (FsDatasetImpl)RamDiskAsyncLazyPersistService.this.datanode.getFSDataset();
            try (FsVolumeReference ref = this.targetVolume;){
                int smallBufferSize = DFSUtilClient.getSmallBufferSize((Configuration)EMPTY_HDFS_CONF);
                FsVolumeImpl volume = (FsVolumeImpl)ref.getVolume();
                File[] targetFiles = volume.copyBlockToLazyPersistLocation(this.bpId, this.blockId, this.genStamp, this.replicaInfo, smallBufferSize, RamDiskAsyncLazyPersistService.this.conf);
                dataset.onCompleteLazyPersist(this.bpId, this.blockId, this.creationTime, targetFiles, volume);
                succeeded = true;
            }
            catch (Exception e) {
                FsDatasetImpl.LOG.warn("LazyWriter failed to async persist RamDisk block pool id: " + this.bpId + "block Id: " + this.blockId, (Throwable)e);
            }
            finally {
                if (!succeeded) {
                    dataset.onFailLazyPersist(this.bpId, this.blockId);
                }
            }
        }
    }
}

