/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileOutputStreamImpl;
import com.ibm.as400.access.IFSKey;
import com.ibm.as400.access.ProxyClientConnection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class IFSFileOutputStreamImplProxy
extends AbstractProxyImpl
implements IFSFileOutputStreamImpl {
    IFSFileOutputStreamImplProxy() {
        super("IFSFileOutputStream");
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "close");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void connectAndOpen(int ccsid) throws AS400SecurityException, IOException {
        try {
            this.connection_.callMethod(this.pxId_, "connectAndOpen", new Class[]{Integer.TYPE}, new Object[]{ccsid});
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            if (e1 instanceof AS400SecurityException) {
                throw (AS400SecurityException)e1;
            }
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "flush");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public IFSKey lock(long length) throws IOException {
        try {
            return (IFSKey)this.connection_.callMethod(this.pxId_, "lock", new Class[]{Long.TYPE}, new Object[]{length}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void open(int fileDataCCSID) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "open", new Class[]{Integer.TYPE}, new Object[]{fileDataCCSID});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void setAppend(boolean append) {
        try {
            this.connection_.callMethod(this.pxId_, "setAppend", new Class[]{Boolean.TYPE}, new Object[]{append});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void setFD(IFSFileDescriptorImpl fd) {
        try {
            this.connection_.callMethod(this.pxId_, "setFD", new Class[]{IFSFileDescriptorImpl.class}, new Object[]{fd});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    public void unlock(IFSKey key) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "unlock", new Class[]{IFSKey.class}, new Object[]{key});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void write(byte[] data, int dataOffset, int length) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "write", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{data, dataOffset, length});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }

    @Override
    public void writeText(String data, int ccsid) throws IOException {
        try {
            this.connection_.callMethod(this.pxId_, "writeText", new Class[]{String.class, Integer.TYPE}, new Object[]{data, ccsid});
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow1(e);
        }
    }
}

