/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DelegatingDistribution
implements Metric,
Distribution,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;
    private final @UnknownKeyFor @NonNull @Initialized boolean processWideContainer;

    public DelegatingDistribution(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this(name, false);
    }

    public DelegatingDistribution(@UnknownKeyFor @NonNull @Initialized MetricName name, @UnknownKeyFor @NonNull @Initialized boolean processWideContainer) {
        this.name = name;
        this.processWideContainer = processWideContainer;
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized long value) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getDistribution(this.name).update(value);
        }
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized long sum, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized long min, @UnknownKeyFor @NonNull @Initialized long max) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getDistribution(this.name).update(sum, count, min, max);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }
}

