/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.netty.ByteBufUtils;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyMessageDecoder;
import org.apache.flink.runtime.io.network.netty.NetworkBufferAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.util.Preconditions;

class BufferResponseDecoder
extends NettyMessageDecoder {
    private final NetworkBufferAllocator allocator;
    private ByteBuf messageHeaderBuffer;
    @Nullable
    private NettyMessage.BufferResponse bufferResponse;
    private int decodedDataBufferSize;

    BufferResponseDecoder(NetworkBufferAllocator allocator) {
        this.allocator = (NetworkBufferAllocator)Preconditions.checkNotNull((Object)allocator);
    }

    @Override
    public void onChannelActive(ChannelHandlerContext ctx) {
        this.messageHeaderBuffer = ctx.alloc().directBuffer(NettyMessage.BufferResponse.MESSAGE_HEADER_LENGTH);
    }

    @Override
    public NettyMessageDecoder.DecodingResult onChannelRead(ByteBuf data) throws Exception {
        if (this.bufferResponse == null) {
            this.decodeMessageHeader(data);
        }
        if (this.bufferResponse != null) {
            int remainingBufferSize = this.bufferResponse.bufferSize - this.decodedDataBufferSize;
            int actualBytesToDecode = Math.min(data.readableBytes(), remainingBufferSize);
            if (actualBytesToDecode > 0) {
                if (this.bufferResponse.getBuffer() == null) {
                    data.readerIndex(data.readerIndex() + actualBytesToDecode);
                } else {
                    this.bufferResponse.getBuffer().asByteBuf().writeBytes(data, actualBytesToDecode);
                }
                this.decodedDataBufferSize += actualBytesToDecode;
            }
            if (this.decodedDataBufferSize == this.bufferResponse.bufferSize) {
                NettyMessage.BufferResponse result = this.bufferResponse;
                this.clearState();
                return NettyMessageDecoder.DecodingResult.fullMessage(result);
            }
        }
        return NettyMessageDecoder.DecodingResult.NOT_FINISHED;
    }

    private void decodeMessageHeader(ByteBuf data) {
        ByteBuf fullFrameHeaderBuf = ByteBufUtils.accumulate(this.messageHeaderBuffer, data, NettyMessage.BufferResponse.MESSAGE_HEADER_LENGTH, this.messageHeaderBuffer.readableBytes());
        if (fullFrameHeaderBuf != null) {
            this.bufferResponse = NettyMessage.BufferResponse.readFrom(fullFrameHeaderBuf, this.allocator);
        }
    }

    private void clearState() {
        this.bufferResponse = null;
        this.decodedDataBufferSize = 0;
        this.messageHeaderBuffer.clear();
    }

    @Override
    public void close() {
        if (this.bufferResponse != null) {
            this.bufferResponse.releaseBuffer();
        }
        this.messageHeaderBuffer.release();
    }
}

