/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.base.Ticker;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.FutureCallback;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.tracing.TraceScope;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Groups {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(Groups.class);
    private final GroupMappingServiceProvider impl;
    private final LoadingCache<String, Set<String>> cache;
    private final AtomicReference<Map<String, Set<String>>> staticMapRef = new AtomicReference();
    private final long cacheTimeout;
    private final long negativeCacheTimeout;
    private final long warningDeltaMs;
    private final Timer timer;
    private Set<String> negativeCache;
    private final boolean reloadGroupsInBackground;
    private final int reloadGroupsThreadCount;
    private final AtomicLong backgroundRefreshSuccess = new AtomicLong(0L);
    private final AtomicLong backgroundRefreshException = new AtomicLong(0L);
    private final AtomicLong backgroundRefreshQueued = new AtomicLong(0L);
    private final AtomicLong backgroundRefreshRunning = new AtomicLong(0L);
    private static Groups GROUPS = null;

    public Groups(Configuration conf) {
        this(conf, new Timer());
    }

    public Groups(Configuration conf, Timer timer) {
        this.impl = ReflectionUtils.newInstance(conf.getClass("hadoop.security.group.mapping", JniBasedUnixGroupsMappingWithFallback.class, GroupMappingServiceProvider.class), conf);
        this.cacheTimeout = conf.getLong("hadoop.security.groups.cache.secs", 300L) * 1000L;
        this.negativeCacheTimeout = conf.getLong("hadoop.security.groups.negative-cache.secs", 30L) * 1000L;
        this.warningDeltaMs = conf.getLong("hadoop.security.groups.cache.warn.after.ms", 5000L);
        this.reloadGroupsInBackground = conf.getBoolean("hadoop.security.groups.cache.background.reload", false);
        this.reloadGroupsThreadCount = conf.getInt("hadoop.security.groups.cache.background.reload.threads", 3);
        this.parseStaticMapping(conf);
        this.timer = timer;
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(this.cacheTimeout, TimeUnit.MILLISECONDS).ticker((Ticker)new TimerToTickerAdapter(timer)).expireAfterWrite(10L * this.cacheTimeout, TimeUnit.MILLISECONDS).build((CacheLoader)new GroupCacheLoader());
        if (this.negativeCacheTimeout > 0L) {
            Cache tempMap = CacheBuilder.newBuilder().expireAfterWrite(this.negativeCacheTimeout, TimeUnit.MILLISECONDS).ticker((Ticker)new TimerToTickerAdapter(timer)).build();
            this.negativeCache = Collections.newSetFromMap(tempMap.asMap());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Group mapping impl=" + this.impl.getClass().getName() + "; cacheTimeout=" + this.cacheTimeout + "; warningDeltaMs=" + this.warningDeltaMs);
        }
    }

    @VisibleForTesting
    Set<String> getNegativeCache() {
        return this.negativeCache;
    }

    private void parseStaticMapping(Configuration conf) {
        String staticMapping = conf.get("hadoop.user.group.static.mapping.overrides", "dr.who=;");
        Collection<String> mappings = StringUtils.getStringCollection(staticMapping, ";");
        HashMap staticUserToGroupsMap = new HashMap();
        for (String users : mappings) {
            Collection<String> userToGroups = StringUtils.getStringCollection(users, "=");
            if (userToGroups.size() < 1 || userToGroups.size() > 2) {
                throw new HadoopIllegalArgumentException("Configuration hadoop.user.group.static.mapping.overrides is invalid");
            }
            String[] userToGroupsArray = userToGroups.toArray(new String[userToGroups.size()]);
            String user = userToGroupsArray[0];
            Set groups = Collections.emptySet();
            if (userToGroupsArray.length == 2) {
                groups = new LinkedHashSet<String>(StringUtils.getStringCollection(userToGroupsArray[1]));
            }
            staticUserToGroupsMap.put(user, groups);
        }
        this.staticMapRef.set(staticUserToGroupsMap.isEmpty() ? null : staticUserToGroupsMap);
    }

    private boolean isNegativeCacheEnabled() {
        return this.negativeCacheTimeout > 0L;
    }

    private IOException noGroupsForUser(String user) {
        return new IOException("No groups found for user " + user);
    }

    @Deprecated
    public List<String> getGroups(String user) throws IOException {
        return Collections.unmodifiableList(new ArrayList<String>(this.getGroupInternal(user)));
    }

    public Set<String> getGroupsSet(String user) throws IOException {
        return Collections.unmodifiableSet(this.getGroupInternal(user));
    }

    private Set<String> getGroupInternal(String user) throws IOException {
        Set<String> staticMapping;
        Map<String, Set<String>> staticUserToGroupsMap = this.staticMapRef.get();
        if (staticUserToGroupsMap != null && (staticMapping = staticUserToGroupsMap.get(user)) != null) {
            return staticMapping;
        }
        if (this.isNegativeCacheEnabled() && this.negativeCache.contains(user)) {
            throw this.noGroupsForUser(user);
        }
        try {
            return (Set)this.cache.get((Object)user);
        }
        catch (ExecutionException e) {
            throw (IOException)e.getCause();
        }
    }

    public long getBackgroundRefreshSuccess() {
        return this.backgroundRefreshSuccess.get();
    }

    public long getBackgroundRefreshException() {
        return this.backgroundRefreshException.get();
    }

    public long getBackgroundRefreshQueued() {
        return this.backgroundRefreshQueued.get();
    }

    public long getBackgroundRefreshRunning() {
        return this.backgroundRefreshRunning.get();
    }

    public void refresh() {
        LOG.info("clearing userToGroupsMap cache");
        try {
            this.impl.cacheGroupsRefresh();
        }
        catch (IOException e) {
            LOG.warn("Error refreshing groups cache", (Throwable)e);
        }
        this.cache.invalidateAll();
        if (this.isNegativeCacheEnabled()) {
            this.negativeCache.clear();
        }
    }

    public void cacheGroupsAdd(List<String> groups) {
        try {
            this.impl.cacheGroupsAdd(groups);
        }
        catch (IOException e) {
            LOG.warn("Error caching groups", (Throwable)e);
        }
    }

    public static Groups getUserToGroupsMappingService() {
        return Groups.getUserToGroupsMappingService(new Configuration());
    }

    public static synchronized Groups getUserToGroupsMappingService(Configuration conf) {
        if (GROUPS == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Creating new Groups object");
            }
            GROUPS = new Groups(conf);
        }
        return GROUPS;
    }

    @InterfaceAudience.Private
    public static synchronized Groups getUserToGroupsMappingServiceWithLoadedConfiguration(Configuration conf) {
        GROUPS = new Groups(conf);
        return GROUPS;
    }

    @VisibleForTesting
    public static void reset() {
        GROUPS = null;
    }

    private class GroupCacheLoader
    extends CacheLoader<String, Set<String>> {
        private ListeningExecutorService executorService;

        GroupCacheLoader() {
            if (Groups.this.reloadGroupsInBackground) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Group-Cache-Reload").setDaemon(true).build();
                ThreadPoolExecutor parentExecutor = new ThreadPoolExecutor(Groups.this.reloadGroupsThreadCount, Groups.this.reloadGroupsThreadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
                parentExecutor.allowCoreThreadTimeOut(true);
                this.executorService = MoreExecutors.listeningDecorator((ExecutorService)parentExecutor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> load(String user) throws Exception {
            LOG.debug("GroupCacheLoader - load.");
            TraceScope scope = null;
            Tracer tracer = Tracer.curThreadTracer();
            if (tracer != null) {
                scope = tracer.newScope("Groups#fetchGroupList");
                scope.addKVAnnotation("user", user);
            }
            Set<String> groups = null;
            try {
                groups = this.fetchGroupSet(user);
            }
            finally {
                if (scope != null) {
                    scope.close();
                }
            }
            if (groups.isEmpty()) {
                if (Groups.this.isNegativeCacheEnabled()) {
                    Groups.this.negativeCache.add(user);
                }
                throw Groups.this.noGroupsForUser(user);
            }
            return groups;
        }

        public ListenableFuture<Set<String>> reload(String key, Set<String> oldValue) throws Exception {
            LOG.debug("GroupCacheLoader - reload (async).");
            if (!Groups.this.reloadGroupsInBackground) {
                return super.reload((Object)key, oldValue);
            }
            Groups.this.backgroundRefreshQueued.incrementAndGet();
            ListenableFuture listenableFuture = this.executorService.submit(() -> {
                Groups.this.backgroundRefreshQueued.decrementAndGet();
                Groups.this.backgroundRefreshRunning.incrementAndGet();
                Set<String> results = this.load(key);
                return results;
            });
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<Set<String>>(){

                public void onSuccess(Set<String> result) {
                    Groups.this.backgroundRefreshSuccess.incrementAndGet();
                    Groups.this.backgroundRefreshRunning.decrementAndGet();
                }

                public void onFailure(Throwable t) {
                    Groups.this.backgroundRefreshException.incrementAndGet();
                    Groups.this.backgroundRefreshRunning.decrementAndGet();
                }
            }, (Executor)MoreExecutors.directExecutor());
            return listenableFuture;
        }

        private Set<String> fetchGroupSet(String user) throws IOException {
            long startMs = Groups.this.timer.monotonicNow();
            Set<String> groups = Groups.this.impl.getGroupsSet(user);
            long endMs = Groups.this.timer.monotonicNow();
            long deltaMs = endMs - startMs;
            UserGroupInformation.metrics.addGetGroups(deltaMs);
            if (deltaMs > Groups.this.warningDeltaMs) {
                LOG.warn("Potential performance problem: getGroups(user=" + user + ") took " + deltaMs + " milliseconds.");
            }
            return groups;
        }
    }

    private static class TimerToTickerAdapter
    extends Ticker {
        private Timer timer;

        public TimerToTickerAdapter(Timer timer) {
            this.timer = timer;
        }

        public long read() {
            long NANOSECONDS_PER_MS = 1000000L;
            return this.timer.monotonicNow() * 1000000L;
        }
    }
}

