/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.propertyoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.propertyoutput.PropertyOutput;
import org.apache.hop.pipeline.transforms.propertyoutput.PropertyOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="PropertyOutput", image="propertyoutput.svg", name="i18n::PropertyOutput.Name", description="i18n::PropertyOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::PropertyOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/propertyoutput.html")
public class PropertyOutputMeta
extends BaseTransformMeta<PropertyOutput, PropertyOutputData> {
    private static final Class<?> PKG = PropertyOutputMeta.class;
    public static final String CONST_SPACES_LONG = "      ";
    public static final String CONST_SPACES = "    ";
    private String keyfield;
    private String valuefield;
    private boolean addToResult;
    private String fileName;
    private boolean fileNameInField;
    private String fileNameField;
    private String extension;
    private boolean transformNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean createparentfolder;
    private String comment;
    private boolean append;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        PropertyOutputMeta retval = (PropertyOutputMeta)((Object)super.clone());
        return retval;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFileNameInField() {
        return this.fileNameInField;
    }

    public void setFileNameInField(boolean fileNameInField) {
        this.fileNameInField = fileNameInField;
    }

    public String getFileNameField() {
        return this.fileNameField;
    }

    public void setFileNameField(String fileNameField) {
        this.fileNameField = fileNameField;
    }

    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    public void setTransformNrInFilename(boolean transformNrInFilename) {
        this.transformNrInFilename = transformNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isAddToResult() {
        return this.addToResult;
    }

    public void setAddToResult(boolean addToResult) {
        this.addToResult = addToResult;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String commentin) {
        this.comment = commentin;
    }

    public String[] getFiles(IVariables variables) {
        int nr;
        int copies = 1;
        int parts = 1;
        if (this.transformNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if ((nr = copies * parts) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                retval[i] = this.buildFilename(variables, copy);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(IVariables variables, int transformnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        Object retval = variables.resolve(this.fileName);
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = (String)retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = (String)retval + "_" + t;
        }
        if (this.transformNrInFilename) {
            retval = (String)retval + "_" + transformnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = (String)retval + "." + this.extension;
        }
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.keyfield = XmlHandler.getTagValue((Node)transformNode, (String)"keyfield");
            this.valuefield = XmlHandler.getTagValue((Node)transformNode, (String)"valuefield");
            this.comment = XmlHandler.getTagValue((Node)transformNode, (String)"comment");
            this.fileName = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"create_parent_folder"));
            this.extension = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extention"), (String)XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"extension"));
            this.transformNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"add_time"));
            this.addToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"AddToResult"));
            this.append = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"append"));
            this.fileName = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
            this.fileNameInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"fileNameInField"));
            this.fileNameField = XmlHandler.getTagValue((Node)transformNode, (String)"fileNameField");
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.append = false;
        this.createparentfolder = false;
        this.keyfield = null;
        this.valuefield = null;
        this.comment = null;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"keyfield", (String)this.keyfield));
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"valuefield", (String)this.valuefield));
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"fileNameInField", (boolean)this.fileNameInField));
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"fileNameField", (String)this.fileNameField));
        retval.append("    <file>" + Const.CR);
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"split", (boolean)this.transformNrInFilename));
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append(CONST_SPACES_LONG + XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"addtoresult", (boolean)this.addToResult));
        retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"append", (boolean)this.append));
        retval.append("      </file>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (!Utils.isEmpty((CharSequence)this.fileName)) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.FilenameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.FilenameError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IValueMeta v = prev.searchValueMeta(this.keyfield);
        if (v == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.KeyFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.KeyFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        v = prev.searchValueMeta(this.valuefield);
        if (v == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ValueFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ValueFieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getKeyField() {
        return this.keyfield;
    }

    public String getValueField() {
        return this.valuefield;
    }

    public void setKeyField(String keyField) {
        this.keyfield = keyField;
    }

    public void setValueField(String valuefield) {
        this.valuefield = valuefield;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject;
            if (!this.fileNameInField && (fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName))).exists()) {
                this.fileName = iResourceNaming.nameResource(fileObject, variables, true);
                return this.fileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

