/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.logging.HopLogLayout;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.IHasLogChannel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILogParentProvided;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.ExecutorUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.text.Format;
import org.apache.hop.ui.core.widget.text.TextFormatter;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class HopGuiLogBrowser {
    private static final Class<?> PKG = HopGui.class;
    private Text text;
    private ILogParentProvided logProvider;
    private List<String> childIds = new ArrayList<String>();
    private Date lastLogRegistryChange;
    private AtomicBoolean paused;

    public HopGuiLogBrowser(Text text, ILogParentProvided logProvider) {
        this.text = text;
        this.logProvider = logProvider;
        this.paused = new AtomicBoolean(false);
    }

    public void installLogSniffer() {
        final AtomicInteger lastLogId = new AtomicInteger(-1);
        final AtomicBoolean busy = new AtomicBoolean(false);
        final HopLogLayout logLayout = new HopLogLayout(true);
        Timer logRefreshTimer = new Timer("log sniffer Timer");
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (HopGuiLogBrowser.this.text.isDisposed() || HopGuiLogBrowser.this.text.getDisplay().isDisposed()) {
                    return;
                }
                HopGuiLogBrowser.this.text.getDisplay().asyncExec(() -> {
                    IHasLogChannel provider = HopGuiLogBrowser.this.logProvider.getLogChannelProvider();
                    if (provider != null && !HopGuiLogBrowser.this.text.isDisposed() && !busy.get() && !HopGuiLogBrowser.this.paused.get() && HopGuiLogBrowser.this.text.isVisible()) {
                        busy.set(true);
                        ILogChannel logChannel = provider.getLogChannel();
                        if (logChannel != null) {
                            int lastNr;
                            String parentLogChannelId = logChannel.getLogChannelId();
                            LoggingRegistry registry = LoggingRegistry.getInstance();
                            Date registryModDate = registry.getLastModificationTime();
                            if (HopGuiLogBrowser.this.childIds == null || HopGuiLogBrowser.this.lastLogRegistryChange == null || registryModDate.compareTo(HopGuiLogBrowser.this.lastLogRegistryChange) > 0) {
                                HopGuiLogBrowser.this.lastLogRegistryChange = registry.getLastModificationTime();
                                HopGuiLogBrowser.this.childIds = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
                            }
                            if ((lastNr = HopLogStore.getLastBufferLineNr()) > lastLogId.get()) {
                                List logLines = HopLogStore.getLogBufferFromTo(HopGuiLogBrowser.this.childIds, (boolean)true, (int)lastLogId.get(), (int)lastNr);
                                DescribedVariable describedVariable = HopConfig.getInstance().findDescribedVariable("HOP_MAX_LOG_SIZE_IN_LINES");
                                int maxSize = describedVariable == null ? 5000 : Const.toInt((String)describedVariable.getValue(), (int)5000);
                                Text text = HopGuiLogBrowser.this.text;
                                synchronized (text) {
                                    for (HopLoggingEvent event : logLines) {
                                        String line = logLayout.format(event).trim();
                                        int length = line.length();
                                        if (length <= 0) continue;
                                        Format format = TextFormatter.getInstance().execute(line);
                                        HopGuiLogBrowser.this.text.append(format.getText());
                                        HopGuiLogBrowser.this.text.append(Const.CR);
                                    }
                                }
                                int size = !EnvironmentUtils.getInstance().isWeb() ? HopGuiLogBrowser.this.text.getLineCount() : HopGuiLogBrowser.this.text.getText().length();
                                if (maxSize > 0 && size > maxSize) {
                                    int dropIndex = StringUtils.lastOrdinalIndexOf((CharSequence)HopGuiLogBrowser.this.text.getText(), (CharSequence)"\n", (int)(maxSize + 1));
                                    HopGuiLogBrowser.this.text.setText(HopGuiLogBrowser.this.text.getText().substring(dropIndex + 1));
                                }
                                HopGuiLogBrowser.this.text.setSelection(HopGuiLogBrowser.this.text.getText().length());
                                lastLogId.set(lastNr);
                            }
                        }
                        busy.set(false);
                    }
                });
            }
        };
        logRefreshTimer.schedule(timerTask, Const.toInt((String)EnvUtil.getSystemProperty((String)"HOP_LOG_TAB_REFRESH_DELAY"), (int)1000), (long)Const.toInt((String)EnvUtil.getSystemProperty((String)"HOP_LOG_TAB_REFRESH_PERIOD"), (int)1000));
        this.text.addDisposeListener(event -> ExecutorUtil.cleanup((Timer)logRefreshTimer));
        this.text.getDisplay().disposeExec(logRefreshTimer::cancel);
        final Menu menu = new Menu((Control)this.text);
        MenuItem item = new MenuItem(menu, 0);
        item.setText(BaseMessages.getString(PKG, (String)"LogBrowser.CopySelectionToClipboard.MenuItem", (String[])new String[0]));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selection = HopGuiLogBrowser.this.text.getSelectionText();
                if (!Utils.isEmpty((CharSequence)selection)) {
                    GuiResource.getInstance().toClipboard(selection);
                }
            }
        });
        this.text.setMenu(menu);
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 3) {
                    ConstUi.displayMenu(menu, (Control)HopGuiLogBrowser.this.text);
                }
            }
        });
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    @Generated
    public Text getText() {
        return this.text;
    }

    @Generated
    public ILogParentProvided getLogProvider() {
        return this.logProvider;
    }
}

