/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.roaringbitmap;

import com.clickhouse.client.internal.org.roaringbitmap.ArrayContainer;
import com.clickhouse.client.internal.org.roaringbitmap.BitmapContainer;
import com.clickhouse.client.internal.org.roaringbitmap.Container;
import com.clickhouse.client.internal.org.roaringbitmap.PeekableIntIterator;
import com.clickhouse.client.internal.org.roaringbitmap.RoaringBitmap;
import com.clickhouse.client.internal.org.roaringbitmap.Util;
import java.util.Arrays;
import java.util.BitSet;

public class BitSetUtil {
    private static final int BLOCK_LENGTH = 1024;

    private static ArrayContainer arrayContainerOf(int from, int to, int cardinality, long[] words) {
        char[] content = new char[cardinality];
        int index = 0;
        int i = from;
        int socket = 0;
        while (i < to) {
            long t;
            for (long word = words[i]; word != 0L; word ^= t) {
                t = word & -word;
                content[index++] = (char)(socket + Long.bitCount(t - 1L));
            }
            ++i;
            socket += 64;
        }
        return new ArrayContainer(content);
    }

    public static RoaringBitmap bitmapOf(BitSet bitSet) {
        return BitSetUtil.bitmapOf(bitSet.toLongArray());
    }

    public static RoaringBitmap bitmapOf(long[] words) {
        RoaringBitmap ans = new RoaringBitmap();
        int containerIndex = 0;
        for (int from = 0; from < words.length; from += 1024) {
            int to = Math.min(from + 1024, words.length);
            int blockCardinality = BitSetUtil.cardinality(from, to, words);
            if (blockCardinality <= 0) continue;
            ans.highLowContainer.insertNewKeyValueAt(containerIndex++, Util.highbits(from * 64), BitSetUtil.containerOf(from, to, blockCardinality, words));
        }
        return ans;
    }

    private static int cardinality(int from, int to, long[] words) {
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += Long.bitCount(words[i]);
        }
        return sum;
    }

    private static Container containerOf(int from, int to, int blockCardinality, long[] words) {
        if (blockCardinality <= 4096) {
            return BitSetUtil.arrayContainerOf(from, to, blockCardinality, words);
        }
        return new BitmapContainer(Arrays.copyOfRange(words, from, from + 1024), blockCardinality);
    }

    public static boolean equals(BitSet bitset, RoaringBitmap bitmap) {
        if (bitset.cardinality() != bitmap.getCardinality()) {
            return false;
        }
        PeekableIntIterator it = bitmap.getIntIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (bitset.get(val)) continue;
            return false;
        }
        return true;
    }
}

