/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementPackage;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderEnd16bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart32bit;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.AdapterHelper;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitConverter;

public class AlternativePackaging {
    public UUID guidFileType;
    public UUID guidFile;
    public UUID guidLegacyFileVersion;
    public UUID guidFileFormat;
    public long rgbReserved;
    public StreamObjectHeaderStart32bit packagingStart;
    public ExGuid storageIndexExtendedGUID;
    public UUID guidCellSchemaId;
    public DataElementPackage dataElementPackage;
    public StreamObjectHeaderEnd packagingEnd;

    public int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException, TikaException {
        AtomicInteger index = new AtomicInteger(startIndex);
        this.guidFileType = AdapterHelper.readGuid(byteArray, index.get());
        index.addAndGet(16);
        this.guidFile = AdapterHelper.readGuid(byteArray, index.get());
        index.addAndGet(16);
        this.guidLegacyFileVersion = AdapterHelper.readGuid(byteArray, index.get());
        index.addAndGet(16);
        this.guidFileFormat = AdapterHelper.readGuid(byteArray, index.get());
        index.addAndGet(16);
        this.rgbReserved = BitConverter.toUInt32(byteArray, index.get());
        index.addAndGet(4);
        this.packagingStart = new StreamObjectHeaderStart32bit();
        this.packagingStart.deserializeFromByteArray(byteArray, index.get());
        index.addAndGet(4);
        this.storageIndexExtendedGUID = BasicObject.parse(byteArray, index, ExGuid.class);
        this.guidCellSchemaId = AdapterHelper.readGuid(byteArray, index.get());
        index.addAndGet(16);
        AtomicReference pkg = new AtomicReference();
        StreamObject.tryGetCurrent(byteArray, index, pkg, DataElementPackage.class);
        this.dataElementPackage = (DataElementPackage)pkg.get();
        this.packagingEnd = new StreamObjectHeaderEnd16bit();
        this.packagingEnd.deserializeFromByteArray(byteArray, index.get());
        index.addAndGet(2);
        return index.get() - startIndex;
    }
}

