/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.RemoteEnvironmentConfigUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;

@Public
public class RemoteStreamEnvironment
extends StreamExecutionEnvironment {
    public RemoteStreamEnvironment(String host, int port, String ... jarFiles) {
        this(host, port, (Configuration)null, jarFiles);
    }

    public RemoteStreamEnvironment(String host, int port, Configuration clientConfiguration, String ... jarFiles) {
        this(host, port, clientConfiguration, jarFiles, (URL[])null);
    }

    public RemoteStreamEnvironment(String host, int port, Configuration clientConfiguration, String[] jarFiles, URL[] globalClasspaths) {
        this(host, port, clientConfiguration, jarFiles, globalClasspaths, null);
    }

    @PublicEvolving
    public RemoteStreamEnvironment(String host, int port, Configuration clientConfiguration, String[] jarFiles, URL[] globalClasspaths, SavepointRestoreSettings savepointRestoreSettings) {
        this((PipelineExecutorServiceLoader)new DefaultExecutorServiceLoader(), host, port, clientConfiguration, jarFiles, globalClasspaths, savepointRestoreSettings);
    }

    @PublicEvolving
    public RemoteStreamEnvironment(PipelineExecutorServiceLoader executorServiceLoader, String host, int port, Configuration clientConfiguration, String[] jarFiles, URL[] globalClasspaths, SavepointRestoreSettings savepointRestoreSettings) {
        super(executorServiceLoader, RemoteStreamEnvironment.validateAndGetEffectiveConfiguration(clientConfiguration, host, port, jarFiles, globalClasspaths, savepointRestoreSettings), null);
    }

    private static Configuration getClientConfiguration(Configuration configuration) {
        return configuration == null ? new Configuration() : configuration;
    }

    private static List<URL> getClasspathURLs(URL[] classpaths) {
        return classpaths == null ? Collections.emptyList() : Arrays.asList(classpaths);
    }

    private static Configuration validateAndGetEffectiveConfiguration(Configuration configuration, String host, int port, String[] jarFiles, URL[] classpaths, SavepointRestoreSettings savepointRestoreSettings) {
        RemoteEnvironmentConfigUtils.validate((String)host, (int)port);
        return RemoteStreamEnvironment.getEffectiveConfiguration(RemoteStreamEnvironment.getClientConfiguration(configuration), host, port, jarFiles, RemoteStreamEnvironment.getClasspathURLs(classpaths), savepointRestoreSettings);
    }

    private static Configuration getEffectiveConfiguration(Configuration baseConfiguration, String host, int port, String[] jars, List<URL> classpaths, SavepointRestoreSettings savepointRestoreSettings) {
        Configuration effectiveConfiguration = new Configuration(baseConfiguration);
        RemoteEnvironmentConfigUtils.setJobManagerAddressToConfig((String)host, (int)port, (Configuration)effectiveConfiguration);
        RemoteEnvironmentConfigUtils.setJarURLsToConfig((String[])jars, (Configuration)effectiveConfiguration);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)effectiveConfiguration, (ConfigOption)PipelineOptions.CLASSPATHS, classpaths, URL::toString);
        if (savepointRestoreSettings != null) {
            SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)savepointRestoreSettings, (Configuration)effectiveConfiguration);
        } else {
            SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)SavepointRestoreSettings.none(), (Configuration)effectiveConfiguration);
        }
        effectiveConfiguration.set(DeploymentOptions.TARGET, (Object)"remote");
        effectiveConfiguration.set(DeploymentOptions.ATTACHED, (Object)true);
        return effectiveConfiguration;
    }

    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        return super.execute(streamGraph);
    }

    public String toString() {
        String host = (String)this.configuration.get(JobManagerOptions.ADDRESS);
        int port = (Integer)this.configuration.get(JobManagerOptions.PORT);
        String parallelism = this.getParallelism() == -1 ? "default" : "" + this.getParallelism();
        return "Remote Environment (" + host + ":" + port + " - parallelism = " + parallelism + ").";
    }

    public String getHost() {
        return (String)this.configuration.get(JobManagerOptions.ADDRESS);
    }

    public int getPort() {
        return (Integer)this.configuration.get(JobManagerOptions.PORT);
    }

    @Deprecated
    public Configuration getClientConfiguration() {
        return this.configuration;
    }
}

