/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffScalarCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.IntWritable;

@Description(name="datediff", value="_FUNC_(date1, date2) - Returns the number of days between date1 and date2", extended="date1 and date2 are strings in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time parts are ignored.If date1 is earlier than date2, the result is negative.\nExample:\n   > SELECT _FUNC_('2009-07-30', '2009-07-31') FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={VectorUDFDateDiffColScalar.class, VectorUDFDateDiffColCol.class, VectorUDFDateDiffScalarCol.class})
public class GenericUDFDateDiff
extends GenericUDF {
    private final transient ObjectInspectorConverters.Converter[] tsConverters = new ObjectInspectorConverters.Converter[2];
    private IntWritable output = new IntWritable();
    private final transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        for (int i = 0; i < arguments.length; ++i) {
            this.checkArgPrimitive(arguments, i);
            this.checkArgGroups(arguments, i, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP);
            this.obtainTimestampConverter(arguments, i, this.tsInputTypes, this.tsConverters);
        }
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    public IntWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Timestamp ts1 = this.getTimestampValue(arguments, 0, this.tsConverters);
        Timestamp ts2 = this.getTimestampValue(arguments, 1, this.tsConverters);
        if (ts1 == null || ts2 == null) {
            return null;
        }
        this.output.set(DateWritableV2.millisToDays((long)ts1.toEpochMilli()) - DateWritableV2.millisToDays((long)ts2.toEpochMilli()));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("datediff", children);
    }
}

