/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="$SUM0", value="_FUNC_(x) - Returns the sum of a set of numbers, zero if empty")
public class GenericUDAFSumEmptyIsZero
extends GenericUDAFSum {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return new SumLongZeroIfEmpty();
            }
            case TIMESTAMP: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SumDoubleZeroIfEmpty();
            }
            case DECIMAL: {
                return new SumHiveDecimalZeroIfEmpty();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static class SumLongZeroIfEmpty
    extends GenericUDAFSum.GenericUDAFSumLong {
        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFSum.GenericUDAFSumLong.SumLongAgg myagg = (GenericUDAFSum.GenericUDAFSumLong.SumLongAgg)agg;
            ((LongWritable)this.result).set(((Long)myagg.sum).longValue());
            return this.result;
        }
    }

    public static class SumDoubleZeroIfEmpty
    extends GenericUDAFSum.GenericUDAFSumDouble {
        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFSum.GenericUDAFSumDouble.SumDoubleAgg myagg = (GenericUDAFSum.GenericUDAFSumDouble.SumDoubleAgg)agg;
            ((DoubleWritable)this.result).set(((Double)myagg.sum).doubleValue());
            return this.result;
        }
    }

    public static class SumHiveDecimalZeroIfEmpty
    extends GenericUDAFSum.GenericUDAFSumHiveDecimal {
        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            GenericUDAFSum.GenericUDAFSumHiveDecimal.SumHiveDecimalWritableAgg myagg = (GenericUDAFSum.GenericUDAFSumHiveDecimal.SumHiveDecimalWritableAgg)agg;
            ((HiveDecimalWritable)this.result).set((HiveDecimalWritable)myagg.sum);
            return this.result;
        }
    }
}

