/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactory;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactoryImpl;

public abstract class AbstractPrivilegeAnalyzer
extends BaseSemanticAnalyzer {
    protected final HiveAuthorizationTaskFactory hiveAuthorizationTaskFactory;

    public AbstractPrivilegeAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.hiveAuthorizationTaskFactory = this.createAuthorizationTaskFactory(this.conf, this.db);
    }

    @VisibleForTesting
    public AbstractPrivilegeAnalyzer(QueryState queryState, Hive db) throws SemanticException {
        super(queryState, db);
        this.hiveAuthorizationTaskFactory = this.createAuthorizationTaskFactory(this.conf, db);
    }

    private HiveAuthorizationTaskFactory createAuthorizationTaskFactory(HiveConf conf, Hive db) {
        Class authProviderClass = conf.getClass(HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY.varname, HiveAuthorizationTaskFactoryImpl.class, HiveAuthorizationTaskFactory.class);
        try {
            Constructor constructor = authProviderClass.getConstructor(HiveConf.class, Hive.class);
            return (HiveAuthorizationTaskFactory)constructor.newInstance(conf, db);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create instance of " + authProviderClass.getName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void setQueryType(ASTNode tree) {
        this.queryProperties.setQueryType(QueryProperties.QueryType.DCL);
    }
}

