/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStorePasswdAuthenticationProvider;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreConfigAuthenticationProviderImpl
implements MetaStorePasswdAuthenticationProvider {
    private final String userName;
    private final String password;
    protected static final Logger LOG = LoggerFactory.getLogger(MetaStoreConfigAuthenticationProviderImpl.class);

    MetaStoreConfigAuthenticationProviderImpl(Configuration conf) throws AuthenticationException {
        this.userName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_AUTH_CONFIG_USERNAME);
        this.password = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.THRIFT_AUTH_CONFIG_PASSWORD);
        if (null == this.userName || this.userName.isEmpty()) {
            throw new AuthenticationException("No username specified in " + String.valueOf((Object)MetastoreConf.ConfVars.THRIFT_AUTH_CONFIG_USERNAME));
        }
        if (null == this.password) {
            throw new AuthenticationException("No password specified in " + String.valueOf((Object)MetastoreConf.ConfVars.THRIFT_AUTH_CONFIG_PASSWORD));
        }
    }

    @Override
    public void authenticate(String authUser, String authPassword) throws AuthenticationException {
        if (!this.userName.equals(authUser)) {
            LOG.debug("Invalid user " + authUser);
            throw new AuthenticationException("Invalid credentials");
        }
        if (!this.password.equals(authPassword)) {
            LOG.debug("Invalid password for user " + authUser);
            throw new AuthenticationException("Invalid credentials");
        }
        LOG.debug("User " + authUser + " successfully authenticated.");
    }
}

